function  Mesh=setMesh(d,nq,nme,nbe,q,me,be,mel,bel)
% function  Mesh=setMesh(d,nq,nme,nbe,q,me,be,mel,bel)
% Initialization of a Mesh structure. 
%
% Parameters:
%  d: space dimension or dimension of simplices
%  nq: total number of vertices.
%  nme: total number of elements.
%  nbe: total number of boundary edges.
%  q: Array of vertices coordinates, d-by-nq array.
%     q(il,j) is the il-th coordinate of the j-th vertex, il in {1,...,d}
%     and j in {1,...,nq}.
%  me: Connectivity array, (d+1)-by-nme array.
%      me(jl,k) is the storage index of the jl-th  vertex 
%      of the k-th mesh element (d-simplex) in the array q of vertices coordinates,
%      jl in {1,2,...,d+1} and k in {1,...,nme}.
%  mel: Array of elements labels, 1-by-nme array.
%  be: Connectivity array for boundary elements ((d-1)-simplices), d-by-nbe array.
%      be(il,l) is the storage index of the il-th  vertex 
%      of the l-th boundary element in the array q of vertices coordinates,
%      il in {1,...,d} and l in {1,...,nbe}.
%  bel: Array of boundary elements labels, 1-by-nbe array. 
%
% Return values:
%  Mesh: mesh structure (see setMesh.m)
%
% Generated fields of Mesh:
%  vols: Array of d-simplices volumes, 1-by-nme array. vols(k) is the volume
%         of the k-th triangle.
%  h:  maximum edges lengths.
  Mesh=struct('d',d,'q',q,'me',double(me),'mel',double(mel), ...
              'be',double(be),'bel',double(bel), ...
              'nq',nq, ...
              'nme',nme, ...
              'nbe',nbe, ...
              'vols',ComputeVolVec(d,q,me), ...
              'h',GetMaxLengthEdges(q,me));
end