import numpy as np
from scipy.spatial import Delaunay
from scipy import linalg
from math import factorial
from scipy.misc import comb
import itertools
import matplotlib as mpl
from mpl_toolkits.mplot3d import Axes3D
import matplotlib.pyplot as plt
#from . import hypercube

class Mesh:
   def __init__(self, d=0,nq=0,q=[],ql=[],nme=0,me=[],mel=[],vols=[],nbe=0,be=[],bel=[],indve=[]):
      self.d = d
      self.order=1
      self.nq = nq
      self.q=q
      self.ql=ql
      self.nme = nme
      self.me=me
      self.mel=mel
      self.nbe=nbe
      self.be=be
      self.bel=bel
      self.vols=vols 
      self.h=GetMaxLengthEdges(q,me)
     
def HyperCube(d,N=10):
  a=0;b=1
  n_bins =  (N)*np.ones(d)
  bounds = np.repeat([(a,b)], d, axis = 0)

  A = np.mgrid[[slice(row[0], row[1], n*1j) for row, n in zip(bounds, n_bins)]]
  q=np.array([A[i].ravel() for i in range(d)]).T
  q=q[:,range(d-1,-1,-1)]# Matlab like
  me=Delaunay(q).simplices
  nme=me.shape[0];
  volumes=ComputeSignVolVec(q,me)
  Ix=np.where(abs(volumes)<1e-10)[0]
  if Ix.shape[0]>0:
    Ii=np.setdiff1d(range(0,nme),Ix)
    me=me[Ii]
    nme=me.shape[0]
    volumes=volumes[Ii]
  Ix=np.where(volumes<0)[0]
  if Ix.shape[0]>0: # On permute pour etre dans le sens "direct"
    tmp=me[Ix,d]
    me[Ix,d]=me[Ix,d-1]
    me[Ix,d-1]=tmp
  # Boundary
  V=np.array([x for x in itertools.combinations(range(d+1),d)])
  BE=np.array([me[::,V[i]] for i in range(d+1)]).reshape(nme*(d+1),d)
  BE.sort()
  be=np.array([np.array(x) for x in set(tuple(x) for x in BE)]) # equivalent to unique(...,'row') of Matlab 
  nbe=be.shape[0]
  bel=np.zeros(nbe)
  Qb=np.array([q[be[::,i],::] for i in range(d)])
  tol=1e-12
  label=1
  for i in range(d):
    I=np.arange(nbe)
    for j in range(d):
      II=(abs(Qb[j,::,i]-a)<tol).nonzero()[0]
      I=np.intersect1d(I,II)
    bel[I]=label
    label+=1
    I=np.arange(nbe)
    for j in range(d):
      II=(abs(Qb[j,::,i]-b)<tol).nonzero()[0]
      I=np.intersect1d(I,II)
    bel[I]=label
    label+=1
    
  I=(bel==0).nonzero()[0]
  J=np.setdiff1d(np.arange(nbe),I)
  bb=bel[J]
  ii=bb.argsort()
  be=be[J[ii]]
  bel=bel[J[ii]]
  nbe=bel.shape[0] 
  return Mesh(d,q.shape[0],q,[],nme,me,[],abs(volumes),nbe,be,bel)
  
  
def HyperCubeKuhn(d,N):
  q,me=hypercube.GlobalKuhn(N*np.ones((d,)))
  me=me.T
  a=0.;b=1.;
  nme=me.shape[0];
  #volumes=ComputeSignVolVec(q,me)
  #volumes=ComputeSignVolVec(q,me)
  volumes=np.ones((nme,))/nme
  # Boundary
  V=np.array([x for x in itertools.combinations(range(d+1),d)])
  BE=np.array([me[::,V[i]] for i in range(d+1)]).reshape(nme*(d+1),d)
  BE.sort()
  be=np.array([np.array(x) for x in set(tuple(x) for x in BE)]) # equivalent to unique(...,'row') of Matlab 
  nbe=be.shape[0]
  bel=np.zeros(nbe)
  Qb=np.array([q[be[::,i],::] for i in range(d)])
  tol=1e-12
  label=1
  for i in range(d):
    I=np.arange(nbe)
    for j in range(d):
      II=(abs(Qb[j,::,i]-a)<tol).nonzero()[0]
      I=np.intersect1d(I,II)
    bel[I]=label
    label+=1
    I=np.arange(nbe)
    for j in range(d):
      II=(abs(Qb[j,::,i]-b)<tol).nonzero()[0]
      I=np.intersect1d(I,II)
    bel[I]=label
    label+=1
    
  I=(bel==0).nonzero()[0]
  J=np.setdiff1d(np.arange(nbe),I)
  bb=bel[J]
  ii=bb.argsort()
  be=be[J[ii]]
  bel=bel[J[ii]]
  nbe=bel.shape[0] 
  return Mesh(d,q.shape[0],q,[],nme,me,[],abs(volumes),nbe,be,bel)  

def ComputeVolVecOld(d,q,me):
  nme=me.shape[0]
  D=np.zeros((d,d,nme))
  for i in range(d):
    for j in range(1,d+1):
      D[i,j-1]=q[me[::,j],i]-q[me[::,0],i]
  
  C=factorial(d)
  vol=np.array([abs(linalg.det(D[::,::,k])/C) for k in range(D.shape[2])])
  return vol

def ComputeVolVec(d,q,me):
  n=q.shape[1]
  nme=me.shape[0]
  X=np.zeros((d,nme,n))
  for i in range(d):
    X[i]=q[me[::,i+1]]-q[me[::,0]]
  V=np.zeros((d,d,nme))
  for i in range(d):
    V[i,i]=(X[i]*X[i]).sum(axis=1)
    for j in range(i+1,d):
      V[i,j]=V[j,i]=(X[i]*X[j]).sum(axis=1)

  vol=np.array([np.sqrt(abs(linalg.det(V[::,::,k])))/factorial(d) for k in range(nme)])
  return vol
  
def ComputeSignVolVec(q,me):
  n=q.shape[1]
  d=me.shape[1]-1
  assert(d==n)
  nme=me.shape[0]
  X=np.zeros((n,n,nme))
  for i in range(n):
    for j in range(n):
      X[i,j]=(q[me[::,i+1],j]-q[me[::,0],j])
  vol=np.array([linalg.det(X[::,::,k])/factorial(n) for k in range(nme)])
  return vol #,X
  
def GetMeditMesh(meshfile,order):
  fp = open(meshfile, 'rt') 
  nq,q,ql=meditVertices(fp)
  nme,me,mel=meditElements(fp,order,'Tetrahedra',3)
  if nme==0: # 2d mesh
    d=2
    N=factorial(d+order)/(factorial(d)*factorial(order))
    indve=np.array([1,order+1,N])-1
    nme,me,mel=meditElements(fp,order,'Triangles',2)
    nbe,be,bel=meditElements(fp,order,'Edges',1)
  else:
    d=3
    nbe,be,bel=meditElements(fp,order,'Triangles',2)
    N=factorial(d+order)/(factorial(d)*factorial(order))
    indve=np.array([1,order+1,(order+1)*(order+2)/2,N])-1
  fp.close()
  volumes=ComputeVolVec(d,q,me)
  return Mesh(d,nq,q,ql,nme,me,mel,volumes,nbe,be,bel,indve)

def meditVertices(fp):
  fp.seek(0)
  line=''
  while (line.find('Vertices')==-1):
    line = fp.readline()
    if not line:
      return 0,None,None
  nq = np.fromfile(fp, sep=" ", dtype=np.int32, count=1)[0]
  data = np.fromfile(fp, sep=" ", dtype=np.float64, count=4*nq)
  data.shape = (nq,4)
  q=data[:,[0,1,2]]
  ql=np.int32(data[:,3])
  return nq,q,ql

def  meditElements(fp,order,ElementStr,d):
  fp.seek(0)
  N=np.int32(factorial(d+order)/(factorial(d)*factorial(order)))
  line=''
  while (line.find(ElementStr)==-1):
    line = fp.readline()
    if not line:
      return 0,None,None
  nme = np.fromfile(fp, sep=" ", dtype=np.int32, count=1)[0]
  data = np.fromfile(fp, sep=" ", dtype=np.int32, count=(N+1)*nme)
  data.shape = (nme,N+1)
  me=data[:,range(N)]-1
  mel=data[:,N]
  return nme,me,mel
  
def readFreeFEM(meshfile):
  fp = open(meshfile, 'rt') 
  nq, nme, nbe = np.fromfile(fp, sep=" ", dtype=np.int32, count=3)
  data = np.fromfile(fp, sep=" ", dtype=np.float64, count=3*nq)
  data.shape = (nq,3)
  q=data[:,[0,1]]
  ql=np.int32(data[:,2])
  data = np.fromfile(fp, sep=" ", dtype=np.int32, count=4*nme)
  data.shape=(nme,4)
  me=data[:,[0,1,2]]-1
  mel=data[:,3]
  data = np.fromfile(fp, sep=" ", dtype=np.int32, count=3*nbe)
  data.shape=(nbe,3)
  be=data[:,[0,1]]-1
  bel=data[:,2]
  volumes=ComputeVolVec(2,q,me)
  h=GetMaxLengthEdges(q,me)
  return Mesh(2,nq,q,ql,nme,me,mel,volumes,nbe,be,bel)

#def readFreeFEM3D(meshfile):
  #fp = open(meshfile, 'rt') 
  #nq, nme, nbe = np.fromfile(fp, sep=" ", dtype=np.int32, count=3)
  #data = np.fromfile(fp, sep=" ", dtype=np.float64, count=4*nq)
  #data.shape = (nq,4)
  #q=data[:,[0,1,2]]
  #ql=np.int32(data[:,3])
  #data = np.fromfile(fp, sep=" ", dtype=np.int32, count=5*nme)
  #data.shape=(nme,5)
  #me=data[:,[0,1,2,3]]-1
  #mel=data[:,4]
  #data = np.fromfile(fp, sep=" ", dtype=np.int32, count=4*nbe)
  #data.shape=(nbe,4)
  #be=data[:,[0,1,2]]-1
  #bel=data[:,3]
  #volumes=ComputeVolVec(3,q,me)
  #return Mesh(3,nq,q,ql,nme,me,mel,volumes,nbe,be,bel)
  
  
  
def readFreeFEM3D(filename):
  fp = open(filename, 'rt')
  line=''
  while (line.find('Vertices')==-1):
    line = fp.readline()
  nq = np.fromfile(fp, sep=" ", dtype=np.int32, count=1)[0]
  data = np.fromfile(fp, sep=" ", dtype=np.float64, count=4*nq)
  data.shape = (nq,4)
  q=data[:,[0,1,2]]
  ql=np.int32(data[:,3])
  fp.seek(0)
  line=''
  while (line.find('Triangles')==-1):
    line = fp.readline()
  nbe = np.fromfile(fp, sep=" ", dtype=np.int32, count=1)[0]
  data = np.fromfile(fp, sep=" ", dtype=np.int32, count=4*nbe)
  data.shape = (nbe,4)
  be=data[:,[0,1,2]]-1
  bel=data[:,3]
  fp.seek(0)
  line=''
  while (line.find('Tetrahedra')==-1):
    line = fp.readline()
  nme = np.fromfile(fp, sep=" ", dtype=np.int32, count=1)[0]
  data = np.fromfile(fp, sep=" ", dtype=np.int32, count=5*nme)
  data.shape = (nme,5)
  me=data[:,[0,1,2,3]]-1
  mel=data[:,4]
  fp.close()
  volumes=ComputeVolVec(3,q,me)
  return Mesh(3,nq,q,ql,nme,me,mel,volumes,nbe,be,bel)
  
def GetMaxLengthEdges(q,me):
  ne=me.shape[1]
  h=0.
  for i in range(ne):
    for j in range(i+1,ne):
      h=max(h,np.sum((q[me[::,i]]-q[me[::,j]])**2,axis=1).max())
  return np.sqrt(h)
