# 4) Plot functions
  
def PlotTetra(ql):
  import matplotlib as mpl
  from mpl_toolkits.mplot3d import Axes3D
  import numpy as np
  import matplotlib.pyplot as plt
  fig = plt.figure()
  ax = fig.gca(projection='3d')
  Q=ql.T
  ax.plot(Q[0], Q[1], Q[2])
  Q=np.array([ql[3],ql[1]]).T
  ax.plot(Q[0], Q[1], Q[2])
  Q=array([ql[0],ql[2]]).T
  ax.plot(Q[0], Q[1], Q[2])
  Q=np.array([ql[0],ql[3]]).T
  ax.plot(Q[0], Q[1], Q[2])
  plt.show()
  
def PlotTetraAx(ax,ql,color):
  Q=ql.T
  ax.plot(Q[0], Q[1], Q[2],color)
  Q=np.array([ql[3],ql[1]]).T
  ax.plot(Q[0], Q[1], Q[2],color)
  Q=np.array([ql[0],ql[2]]).T
  ax.plot(Q[0], Q[1], Q[2],color)
  Q=np.array([ql[0],ql[3]]).T
  ax.plot(Q[0], Q[1], Q[2],color)
  
def PlotMesh3D(Th,kk):
  fig = plt.figure()
  ax = fig.gca(projection='3d')
  nme=Th.nme
  for k in range(0,kk):
    PlotTetraAx(ax,Th.q[Th.me[k]],'b')
  for k in range(kk+1,nme):
    PlotTetraAx(ax,Th.q[Th.me[k]],'b')
  PlotTetraAx(ax,Th.q[Th.me[kk]],'r')
  plt.show()
  
def PlotMesh2D(Th):
  #if M.version==0:
  plt.triplot(Th.q[:,0],Th.q[:,1],Th.me,'bo-')
  #elif M.version==1:
  #  plt.triplot(M.q[0],M.q[1],M.me,'bo-')
  plt.axis('equal')
  plt.axis('off')
  plt.show()
 
def PlotContour2D(Th,val): 
  plt.figure()
  plt.gca().set_aspect('equal')
  plt.tricontourf(Th.q[:,0], Th.q[:,1], Th.me, val)
  plt.colorbar()
  plt.show()