function [q,me]=Triangulation(N)
% FUNCTION CartesianGrid.Triangulation: Tessallations by d-simplices
%     of the cartesian grid.
%
% USAGE
%   [q,me]=CartesianGrid.Triangulation(N) 
% 
% INPUT
%   N : 1-by-d array. Specify the cartesian grid [0,N(1)]x...x[0,N(d)].
%
% OUTPUT
%   q : d-by-nq array with nq=(N(1)+1)x...x(N(d)+1). 
%       Contains all the points of the cartesian grid
%   me: (d+1)-by-nme array with nme=d!xN(1)x...xN(d).
%       Connectivity array of the triangulation.
%
%    <COPYRIGHT>
% 
  d=length(N);
  q=CartesianGrid.points(N);
  Hinv=CartesianGrid.points(N-1);
  Nh=size(Hinv,2);
  beta=CartesianGrid.beta(N) ;
  ibase=beta*Hinv+1;
  [qK,meK]=CartesianGrid.KuhnTriangulation(d);
  fd=factorial(d);
  me=zeros(d+1,fd*Nh);
  Idx=fd*[0:(Nh-1)];
  for l=1:fd
    Idx=Idx+1;
    for j=1:d+1
       me(j,Idx)=ibase+beta*qK(:,meK(j,l));
    end
  end
end

