function P=Permutations(n)
% FUNCTION HyperMesh.Permutations: all permutations of 1:n elements
%   sorted in lexicographical order.
%
% USAGE
%   P=HyperMesh.Permutations(n) 
% 
% INPUT
%   n : integer, n>1.
%
% OUTPUT
%   P : n!-by-n array. Contains all the permutations of 1:n elements.
%
%    Parts of GNU Octave oHyperMesh package.
%    Copyright (C) 2016 Francois Cuvelier <cuvelier@math.univ-paris13.fr>
% 
if n<=1,P=1;return;end
if n==2,P=[1,2;2,1];return;end
pP=fc_hypermesh.Permutations(n-1);
P=zeros(factorial(n),n);
nl=size(pP,1);
ind=1:nl;
for i=n:-1:1
  j=setdiff(1:n,i);
  P(ind,j)=pP;
  P(ind,i)=n;
  ind=ind+nl;
end
P=sortrows(P);