function varargout=configure(varargin)
% FUNCTION fc_hypermesh.configure()
%   Configures the toolbox/package .
%   Theses informations will be stored in ... file.
%
% <COPYRIGHT>
  [conffile,isFileExists]=fc_hypermesh.getLocalConfFile();
  if isFileExists
    run(conffile);
  else
    fc_tools_dir=''; % empty if pkg or toolbox in path
  end
  p = inputParser;
  p.addParamValue('fc_tools_dir',fc_tools_dir,@ischar);
  %p.addParamValue('force',false,@islogical); 
  p.parse(varargin{:});
  R=p.Results;
  
  fprintf('Write in %s ...\n',conffile);
  fid=fopen(conffile,'w');
  if (fid==0), error('Unable to open file :\n %s\n',conffile);end
  fprintf(fid,'%% Automaticaly generated with fc_hypermesh.configure()\n');
  fprintf(fid,'fc_tools_dir=''%s'';\n',R.fc_tools_dir);
  fclose(fid);
  fprintf('  -> done\n');
  if nargout==1,varargout{1}=conffile;end
end

