function [q,me]=KuhnTriangulation(d)
% FUNCTION CartesianGrid.KuhnTriangulation: Kuhn's triangulation of the 
%     unit d-hypercube with d! d-simplices.
%
% USAGE
%   [q,me]=CartesianGrid.KuhnTriangulation(d)
% 
% INPUT
%   d : space dimension.
%
% OUTPUT
%   q : d-by-2^d array. Contains all the vertices of the unit-hypercube.
%   me: (d+1)-by-d! array. Connectivity array of the triangulation.
%
%    <COPYRIGHT>
  q=CartesianGrid.points(ones(1,d));
  qref=[zeros(d,1),triu(ones(d))];
  P=fc_hypermesh.Permutations(d)';
  nme=factorial(d);nq=2^d;
  me=zeros(d+1,nme);
  a=2.^(0:d-1);
  for k=1:nme
    me(:,k)=a*qref(P(:,k),:)+1;
    if ~orientation(q(:,me(:,k)))
      me(1,k)=nq;me(d+1,k)=1; % diagonal permutation
    end
  end
end

function s=orientation(ql)
  d=size(ql,1);
  D=[ql;ones(1,d+1)];
  s=(sign(det(D))==1);
end
