function sTN=TriFaces(N,m)
% FUNCTION CartesianGrid.TriFaces: Triangulations by m-simplices
%     of the m-faces of a cartesian grid.
%
% USAGE
%   sTN=CartesianGrid.TessFaces(N,m) 
% 
% INPUT
%   N : 1-by-d array. Specify the cartesian grid [0,N(1)]x...x[0,N(d)].
%   m : 0<=m<=d.
%
% OUTPUT
%   sTN : array of structure. Contains all the triangulations of
%     the m-faces. (see report)
%         sTN(k).q: points array 
%         sTN(k).me: connectivity array
%         sTN(k).toGlobal: global indices array.
%
%    <COPYRIGHT> 
  d=length(N);
  level=d-m;
  beta=CartesianGrid.beta(N);
  if m==0
    Q=diag(N)*CartesianGrid.points(ones(1,d));
    ind=[beta*Q+1];
    for k=1:size(Q,2)
      sTN(k)=struct('q',Q(:,k),'me',1,'toGlobal',ind(k));
    end
    return
  end
  S=CartesianGrid.points(ones(1,level));
  nc=nchoosek(d,m);
  L=fc_hypermesh.Comb(d,d-m);

  k=1;
  for l=1:nc
    idc=L(l,:); % index constant dimensions
    idnc=setdiff(1:d,idc); % index nonconstant dimensions
    [qw,mew]=CartesianGrid.Triangulation(N(idnc));
    nq=size(qw,2);
    for r=1:2^level
      sTN(k).q=zeros(d,nq);
      sTN(k).q(idnc,:)=qw;
      sTN(k).q(idc,:)=(N(idc)'.*S(:,r))*ones(1,nq);
      sTN(k).me=mew;
      sTN(k).toGlobal=beta*sTN(k).q+1;
      k=k+1;
    end
  end
end

