function init(varargin)
  p = inputParser;
  p.addParamValue('verbose',0,@isscalar);
  p.parse(varargin{:});
  R=p.Results;
  env=fc_hypermesh.environment();
  if isdir(env.fc_tools_dir)
    addpath(env.fc_tools_dir);
  else
    log=ver;
    isOctave=strcmp(log(1).Name,'Octave');
    if isOctave % try pkg load
      Lp=pkg('list');
      if sum(cellfun(@(x) strcmp(x.name,'fc-tools'),Lp))==1 % package is installed
        pkg('load','fc-tools')
      end
    end
  end
  try
    fc_tools.init(varargin{:})
  catch
    fprintf('[fc-hypermesh] Unable to load the fc-tools toolbox/package!\n')
    fprintf('[fc-hypermesh] Use fc_hypermesh.configure(''fc_tools_dir'',<DIR>) to correct this issue\n\n');
    error('fc-hypermesh::init')
  end
  if p.Results.verbose>0
    fprintf('Using <fc-hypermesh> toolbox [%s]\n',fc_hypermesh.version());
  end
end