%% 3D Hypercube [-1,1]x[-2,3]x[-3,3] meshing by simplices
%
% Some *bold*, _italic_, or |monospaced| Text with
% a <http://www.octave.org link to *GNU Octave*>.
%%
type='simplicial';
% %% Generating the mesh by using *OrthMesh* object
Oh=OrthMesh(3,15,'box',[-1 1;-2 2;-3 3],'type',type);

% %% Graphical representations Hypercube mesh
figure(1)
Oh.plot('legend',true)

% %% 2-faces meshes
figure(2)
Oh.plot('m',2,'legend',true)

% ## 1-faces meshes
figure(3)
Oh.plot('m',2,'color',[0.8,0.8,0.8],'EdgeAlpha',0.2,'FaceColor','none')
hold on
Oh.plot('m',1,'Linewidth',2,'legend',true)

% ## 0-faces meshes
figure(4)
Oh.plot('m',1,'color','k')
hold on
Oh.plot('m',0,'legend',true)
