function q=points(N)
% FUNCTION CartesianGrid.points: Returns cartesian grid points.
%
% USAGE
%   q=CartesianGrid.points(N) 
% 
% INPUT
%   N : 1-by-d array. Specify the cartesian grid [0,N(1)]x...x[0,N(d)].
%
% OUTPUT
%   q : d-by-nq array with nq=(N(1)+1)x...x(N(d)+1). 
%       Contains all the points of the cartesian grid
%
%    Parts of GNU Octave oHyperMesh package.
%    Copyright (C) 2016 Francois Cuvelier <cuvelier@math.univ-paris13.fr>
  if isempty(N), q=[];return;end
  d=length(N);nq=prod(N+1);
  q=zeros(d,nq);
  bet=CartesianGrid.beta(N);
  for r=1:d
    q(r,:)=repmat(reshape(repmat(0:N(r),bet(r),1),1,bet(r)*(N(r)+1)),1,prod(N(r+1:d)+1));    
  end
end

