function sQN=TessFaces(N,m)
% FUNCTION CartesianGrid.TessFaces: Tessallations by unit m-hypercubes
%     of the m-faces of a cartesian grid.
%
% USAGE
%   sQN=CartesianGrid.TessFaces(N,m) 
% 
% INPUT
%   N : 1-by-d array. Specify the cartesian grid [0,N(1)]x...x[0,N(d)].
%   m : 0<=m<=d.
%
% OUTPUT
%   sQN : array of structure. Contains all the tessallations of
%     the m-faces. (see report)
%         sQN(k).q: points array 
%         sQN(k).me: connectivity array
%         sQN(k).toGlobal: global indices array.
%
%    Parts of GNU Octave oHyperMesh package.
%    Copyright (C) 2016 Francois Cuvelier <cuvelier@math.univ-paris13.fr>
% 
  d=length(N);
  level=d-m;
  beta=CartesianGrid.beta(N);
  if m==0
    Q=diag(N)*CartesianGrid.points(ones(1,d));
    ind=[beta*Q+1];
    for k=1:size(Q,2)
      sQN(k)=struct('q',Q(:,k),'me',1,'toGlobal',ind(k));
      %sQN(k)=struct('q',Q(:,k),'me',1,'toGlobal',beta*Q(:,k)+1);
    end
    return
  end
  S=CartesianGrid.points(ones(1,level));
  nc=nchoosek(d,m);
  L=HyperMesh.Comb(d,d-m);
  R=flip(HyperMesh.Comb(d,m));

  k=1;
  for l=1:nc
    idc=L(l,:); % index constant dimensions
    idnc=setdiff(1:d,idc); % index nonconstant dimensions
    %[qw,mew]=CartesianGrid.TessHyp(N(R(l,:)));
    [qw,mew]=CartesianGrid.TessHyp(N(idnc));
    nq=size(qw,2);
    for r=1:2^level
      sQN(k).q=zeros(d,nq);
      sQN(k).q(idnc,:)=qw;
      sQN(k).q(idc,:)=(N(idc)'.*S(:,r))*ones(1,nq);
      sQN(k).me=mew;
      sQN(k).toGlobal=beta*sQN(k).q+1;
      k=k+1;
    end
  end
end

