function bench01(d,ctype,Box,LN)
  fprintf('# BENCH in dimension %d with %s mesh\n',d,ctype)
  fprintf('#d: %d\n',d)
  fprintf('#type: %s\n',ctype)
  fprintf('#box: [')
  for i=1:d-1
    fprintf(' %g %g;',Box(i,1),Box(i,2));
  end
  fprintf(' %g %g]\n',Box(d,1),Box(d,2));
  fprintf('#desc:  N        nq       nme    time(s)\n')
  for N=LN
    tstart=tic();
    Oh=OrthMesh(d,N,'box',Box,'type',ctype);
    t=toc(tstart);
    fprintf('     %4d  %8d  %8d     %2.3f\n',N,Oh.Mesh.nq,Oh.Mesh.nme,t);
  end
end
  
