classdef EltMesh < handle % Elementary mesh
  
  properties %(SetAccess = protected)
    d =0; % space dimension  
    m=0;  % m-faces
    type=0; % mesh type : O -> d-simplicial, 1 -> d-orthotope
    nq=0;
    nme=0;
    q  = [];
    me = [];
    toGlobal=[];
    label='';
    %Tag='';
    color=[];
  end
  
  methods
    function self = EltMesh(d,m,q,me,toGlobal,varargin)
      assert( m <= d);
      assert( size(q,1)==d );
      p = inputParser;
      p.addParamValue('color', [0 0 1] );
      p.addParamValue('label', '', @ischar );
      p.parse(varargin{:});
      R=p.Results;
      self.d=d;
      self.m=m;
      self.q=q;
      self.me=me;
      self.toGlobal=toGlobal;
      self.label=R.label;
      self.color=R.color;
      if size(me,1)==m+1 % m-simplicial
        self.type=0;
      elseif size(me,1)==2^m % m-orthotope
        self.type=1;
      else
        error('Trouble with me dimension!')
      end
      self.nq=size(q,2);
      self.nme=size(me,2);
    end
    
  end
end