function varargout=plot(self,varargin)
  %
%    d=log(size(me,1))/log(2); % 2^d
%    dim=size(q,1);
%    assert(ismember(d,0:3));
%    assert(ismember(dim,1:3));
  if self.d>3, error('Unable to plot in dimension > 3!');end
  p = inputParser;
  p.KeepUnmatched=true; 
  p.PartialMatching=false;
  p.addParamValue('color',self.color);
  p.parse(varargin{:});
  R=p.Results;
  varargin=HyperMesh.deleteCellOptions(varargin,p.Parameters);
  
% d=0 : point
% d=1 : line
% d=2 : square
% d=3 : cube
  if self.type==0
    h=eval(sprintf('PlotSubTh%dsimp%dD(self,R.color,varargin)',self.m,self.d));
  else
    h=eval(sprintf('PlotSubQh%dorth%dD(self,R.color,varargin)',self.m,self.d));
  end
  if nargout==1,varargout{1}=h;end
end

function h=PlotSubTh3simp3D(self,Color,PlotOptions)
  view(3)
  idx=nchoosek(1:4,3);
  ME=[];
  for i=1:size(idx,1) 
    ME=[ME;self.me(idx(i,:),:)'];
  end
   h=patch('Vertices',self.q','Faces',ME,'EdgeColor',Color,'FaceColor','none',PlotOptions{:});
end


function h=PlotSubTh2simp3D(self,Color,PlotOptions)
  q=self.q;
  h=trimesh(self.me',q(1,:),q(2,:),q(3,:),'EdgeColor','k','faceColor',Color,PlotOptions{:});
%    Q=[0 0 0;1 0 0;0 1 0];ME=[1 2 3];
%    h1=trimesh(ME,Q(:,1),Q(:,2),Q(:,3),'EdgeColor','k','faceColor',Color,PlotOptions{:},'Visible','Off');
end

function h=PlotSubTh1simp3D(self,Color,PlotOptions)
  X=[self.q(1,self.me(1,:));self.q(1,self.me(2,:))];
  Y=[self.q(2,self.me(1,:));self.q(2,self.me(2,:))];
  Z=[self.q(3,self.me(1,:));self.q(3,self.me(2,:))];
  H=line(X,Y,Z,'Color',Color,PlotOptions{:});
  h=H(1);
end

function h=PlotSubTh0simp3D(self,Color,PlotOptions)
  h=plot3(self.q(1),self.q(2),self.q(3),'LineStyle','none','Marker','o','MarkerFaceColor',Color','Color',Color,PlotOptions{:});
end

function h=PlotSubTh2simp2D(self,Color,PlotOptions)
  q=self.q;
  h=triplot(self.me',q(1,:),q(2,:),'Color',Color,PlotOptions{:});
end

function h=PlotSubTh1simp2D(self,Color,PlotOptions)
  X=[self.q(1,self.me(1,:));self.q(1,self.me(2,:))];
  Y=[self.q(2,self.me(1,:));self.q(2,self.me(2,:))];
  H=line(X,Y,'Color',Color,PlotOptions{:});
  h=H(1);
end

function h=PlotSubTh0simp2D(self,Color,PlotOptions)
  h=plot(self.q(1),self.q(2),'LineStyle','none','Marker','o','MarkerFaceColor',Color','Color',Color,PlotOptions{:});
end

function h=PlotSubTh1simp1D(self,Color,PlotOptions)
  X=[self.q(1,self.me(1,:));self.q(1,self.me(2,:))];
  h=line(X,zeros(2,self.nme),'Color',Color,PlotOptions{:});
end

function h=PlotSubTh0simp1D(self,Color,PlotOptions)
  h=plot(self.q(1),0,'LineStyle','none','Marker','o','MarkerFaceColor',Color','Color',Color,PlotOptions{:});
end

function h=PlotSubQh3orth3D(self,color,PlotOptions)
  idxFace=[1,2,4,3;5,6,8,7;1,3,7,5;2,4,8,6;1,2,6,5;3,4,8,7];
  ME=[];
  for i=1:size(idxFace,1) 
    ME=[ME;self.me(idxFace(i,:),:)'];
  end
  h=patch('Vertices',self.q','Faces',ME,'EdgeColor',color,'FaceColor','none',PlotOptions{:});
end

function h=PlotSubQh2orth3D(self,color,PlotOptions)
  h=patch('Vertices',self.q','Faces',self.me([1,2,4,3],:)','EdgeColor','k','faceColor',color,PlotOptions{:});
end

function h=PlotSubQh1orth3D(self,color,PlotOptions)
  X=[self.q(1,self.me(1,:));self.q(1,self.me(2,:))];
  Y=[self.q(2,self.me(1,:));self.q(2,self.me(2,:))];
  Z=[self.q(3,self.me(1,:));self.q(3,self.me(2,:))];
  h=line(X,Y,Z,'Color',color,PlotOptions{:});
  %h=H(1);
end


function h=PlotSubQh2orth2D(self,color,PlotOptions)
  h=patch('Vertices',self.q','Faces',self.me([1,2,4,3],:)','EdgeColor',color,'FaceColor','none',PlotOptions{:});
end

function h=PlotSubQh1orth2D(self,Color,PlotOptions)
  X=[self.q(1,self.me(1,:));self.q(1,self.me(2,:))];
  Y=[self.q(2,self.me(1,:));self.q(2,self.me(2,:))];
  H=line(X,Y,'Color',Color,PlotOptions{:}); 
  h=H(1);
end

function h=PlotSubQh0orth2D(self,Color,PlotOptions)
  h=PlotSubTh0simp2D(self,Color,PlotOptions);
end

function h=PlotSubQh1orth1D(self,Color,PlotOptions)
  h=PlotSubTh1simp1D(self,Color,PlotOptions);
end

function h=PlotSubQh0orth1D(self,Color,PlotOptions)
  h=PlotSubTh0simp1D(self,Color,PlotOptions);
end
