function b=beta(N)
% FUNCTION CartesianGrid.beta: Returns the beta array associated with
%          the cartesian grid points
%
% USAGE
%   b=CartesianGrid.beta(N) 
% 
% INPUT
%   N : 1-by-d array. Specify the cartesian grid [0,N(1)]x...x[0,N(d)].
%
% OUTPUT
%   b : 1-by-d array 
%       Contains all the beta values
%
%    Parts of GNU Octave oHyperMesh package.
%    Copyright (C) 2016 Francois Cuvelier <cuvelier@math.univ-paris13.fr>
%
  b=[1,cumprod(N(1:end-1)+1)];
end

