function NewOptions=deleteCellOptions(Options,delOptions)
% FUNCTION HyperMesh.deleteCellOptions: delete name/value cells.
%
% USAGE
%   NewOptions=deleteCellOptions(Options,delOptions)
% 
% INPUT
%   Options : cells array with successive name/value pairs 
%   delOptions : cells array with names to delete with their values
%      in Options array.
%
% OUTPUT
%   NewOptions : Options array without name/value pairs specify by delOptions
%
%    Parts of GNU Octave oHyperMesh package.
%    Copyright (C) 2016 Francois Cuvelier <cuvelier@math.univ-paris13.fr>
% 
  assert(iscell(Options))
  if ischar(delOptions),delOptions={ delOptions};end
  n=length(Options);
  isupp=[];
  delOptions=upper(delOptions);
  for i=1:2:n
    I=find(strcmp(upper(Options{i}),delOptions));
    if ~isempty(I)
      isupp=[isupp,i,i+1];
    end
  end
  NewOptions={Options{setdiff(1:n,isupp)}};
end
