function L=Comb(n,m)
% FUNCTION HyperMesh.Comb: combinaisons of 1:n elements taken m at a time.
%
% USAGE
%   L=HyperMesh.Comb(n,m) 
% 
% INPUT
%   n : integer, n>1.
%   m : integer, 1<=m<=n.
%
% OUTPUT
%   L : n!/(m!(n-m)!)-by-m array. Contains all the combinaisons 
%       of 1:n elements taken m at a time. The lexicographical 
%       order is choosen to store all the combinaisons.
%
%    Parts of GNU Octave oHyperMesh package.
%    Copyright (C) 2016 Francois Cuvelier <cuvelier@math.univ-paris13.fr>
% 
if m==1,L=[1:n]';return;end
Lp=HyperMesh.Comb(n,m-1);
nl=nchoosek(n,m);
L=zeros(nl,m);

k=1;
for i=1:size(Lp,1)
  s=Lp(i,m-1)+1:n;
  ns=length(s);
  L(k:k+ns-1,:)=[ones(ns,1)*Lp(i,:),s'];
  k=k+ns;
end

% L=sortrows(nchoosek(1:n,m));
