function [q,me]=TessHyp(N)
% FUNCTION CartesianGrid.TessHyp: Tessallation by unit hypercubes
%     of a cartesian grid.
%
% USAGE
%   [q,me]=CartesianGrid.TessHyp(N) 
% 
% INPUT
%   N : 1-by-d array. Specify the cartesian grid [0,N(1)]x...x[0,N(d)].
%
% OUTPUT
%   q : d-by-nq array with nq=(N(1)+1)x...x(N(d)+1). 
%       Contains all the points of the cartesian grid
%   me: 2^d-by-nme array with nme=N(1)x...xN(d).
%       Connectivity array of the tessallation.
%
%    Parts of GNU Octave oHyperMesh package.
%    Copyright (C) 2016 Francois Cuvelier <cuvelier@math.univ-paris13.fr>
% 
  d=length(N);
  q=CartesianGrid.points(N);
  Hinv=CartesianGrid.points(N-1);
  qhat=CartesianGrid.points(ones(1,d));
  beta=CartesianGrid.beta(N);
  ibase=beta*Hinv+1;
  me=zeros(2^d,length(ibase));
  for l=1:2^d
     me(l,:)=ibase+beta*qhat(:,l);
  end
end

