# -*- coding: utf-8 -*-
import numpy as np

def select_colors(n_colors,**kwargs):
  bg=kwargs.get('backgrounds', np.array([[1,1,1],[0,0,0],[0.8,0.8,0.8],[1,0,1]]) )
  func=kwargs.get('func', lambda x: RGB2LAB(x) )
  n_grid = 30
  h=1/(n_grid-1.);F=1+h/2.
  B,G,R = np.mgrid[0:F:h,0:F:h,0:F:h]
  N=(n_grid)**3
  rgb=np.zeros((N,3))
  rgb[:,0]=R.reshape((N,))
  rgb[:,1]=G.reshape((N,))
  rgb[:,2]=B.reshape((N,))
  lab=func(rgb)
  bglab = func(bg)

  mindist2 = np.ones((N,))*np.inf
  for i in range(bglab.shape[0]-1):
    dX=lab-np.ones((N,1))*bglab[i]  # displacement all colors from bg
    dist2 = np.sum(dX**2,1)  # square distance
    mindist2 = np.minimum(dist2,mindist2)
    
  colors=np.zeros((n_colors,3))
  lastlab = bglab[-1]
  for i in range(n_colors):
    dX = lab-np.ones((N,1))*lastlab
    dist2 = np.sum(dX**2,1)  # square distance
    mindist2 = np.minimum(dist2,mindist2)
    I=np.where(mindist2==mindist2.max())[0][0]
    colors[i]=rgb[I]
    lastlab=lab[I]
  return colors

def RGB2XYZ(rgb):
# by F.C.
  N=rgb.shape[0]
  RGB=np.zeros(rgb.shape)
  RGB[:,0]=rgb[:,0]  # R from 0 to 1
  RGB[:,1]=rgb[:,1]  # G from 0 to 1
  RGB[:,2]=rgb[:,2]  # B from 0 to 1

  for i in range(3):
    I=np.where(RGB[:,i] > 0.0404482362771076)[0]
    RGB[I,i] = ( ( RGB[I,i] + 0.055 ) / 1.055 )** 2.4;
    I=np.setdiff1d(range(N),I);
    RGB[I,i] = RGB[I,i] / 12.92;

    # Observer. = 2°, Illuminant = D65+-
    #  Y = var_R * 0.2126 + var_G * 0.7152 + var_B * 0.0722;
    #  Z = var_R * 0.0193 + var_G * 0.1192 + var_B * 0.9505;
  A=np.array([[0.4123955889674142161,0.3575834307637148171,0.1804926473817015735],
              [0.2125862307855955516,0.7151703037034108499,0.07220049864333622685],
              [0.01929721549174694484,0.1191838645808485318,0.9504971251315797660]]).T
  return np.dot(RGB,A)

def XYZ2LAB(XYZ):
  WHITEPOINT_X=0.950456
  WHITEPOINT_Y=1.0
  WHITEPOINT_Z=1.088754
  X=XYZ[:,0]/WHITEPOINT_X
  Y=XYZ[:,1]/WHITEPOINT_Y
  Z=XYZ[:,2]/WHITEPOINT_Z

  N=XYZ.shape[0]
  LAB=np.zeros((N,3))

  X = LABF(X)
  Y = LABF(Y)
  Z = LABF(Z)
  LAB[:,0] = 116*Y - 16
  LAB[:,1] = 500*(X - Y)
  LAB[:,2] = 200*(Y - Z)
  return LAB

def LABF(t):
  N=len(t);z=0*t;
  I=np.where(t >= 8.85645167903563082e-3)[0]
  z[I]=t[I]**(0.333333333333333)
  I=np.setdiff1d(range(N),I)
  z[I]=(841.0/108.0)*(t[I]) + (4.0/29.0)
  return z

def RGB2LAB(RGB):
# by F.C.
  XYZ=RGB2XYZ(RGB)
  return XYZ2LAB(XYZ)
