import numpy as np

def set_axes_equal(ax):
  #Taken from http://stackoverflow.com/a/31364297/480551
  '''Make axes of 3D plot have equal scale so that spheres appear as spheres,
  cubes as cubes, etc..  This is one possible solution to Matplotlib's
  ax.set_aspect('equal') and ax.axis('equal') not working for 3D.
  Input
    ax: a matplotlib axis, e.g., as output from plt.gca().
  '''
  x_limits = ax.get_xlim3d()
  y_limits = ax.get_ylim3d()
  z_limits = ax.get_zlim3d()
  x_range = x_limits[1] - x_limits[0]; x_mean = np.mean(x_limits)
  y_range = y_limits[1] - y_limits[0]; y_mean = np.mean(y_limits)
  z_range = z_limits[1] - z_limits[0]; z_mean = np.mean(z_limits)
  # The plot bounding box is a sphere in the sense of the infinity
  # norm, hence I call half the max range the plot radius.
  plot_radius = 0.5*max([x_range, y_range, z_range])
  ax.set_xlim3d([x_mean - plot_radius, x_mean + plot_radius])
  ax.set_ylim3d([y_mean - plot_radius, y_mean + plot_radius])
  ax.set_zlim3d([z_mean - plot_radius, z_mean + plot_radius])