% PlotBoundsEdgeNumberfull.m
%  Demo of PlotBoundsEdgeNumberfull function
% PlotMeshNodeNumber and PlotMeshTriangleNumber are also used.
%  The mesh is provided by the meshes.tar.gz archive.
Th=GetMeshOpt('disque4-1-2.msh',2);
PlotMesh(Th,'RGBcolors', selectColors(length( unique(Th.bel))+1));
RGBcolors=PlotBounds(Th,'LineWidth',2);
PlotBoundsEdgeNumber(Th,'RGBEdgeColors', RGBcolors, 'Color',[0 0 0],'LineStyle','-', 'LineWidth',0.5,'FontSize',16);
PlotMeshNodeNumber(Th,'Color',[0 0 1],'FontSize',16);
PlotMeshTriangleNumber(Th,'Color',[1 0 0],'FontSize',16);
set(legend(),'FontSize',24);
if ~isOctave()
set(legend(),'Location','BestOutside');
end
