function Th=gmsh2mesh_octave(gmsh_file,varargin)
% function Th=gmsh2mesh(gmsh_file,varargin)
%
% To define a mesh structure from a mesh created by the software
% gmsh. Works in 2D and 3D cases. Octave version.
%
%

%  gmsh_file='/home/cuvelier/Travail/Recherch/CJS/Mesh/gmsh/3d/part_sphere_2.msh';
  p = inputParser; 
  p=AddParamValue(p,'dim', 2, @isfloat );
  p=Parse(p,varargin{:});
  dim=p.Results.dim;

  [fid,message]=fopen(gmsh_file,'r');
  if ( fid == -1 )
      error([message,' : ',gmsh_file]);
  end
  
  while ( 1 )
    text = fgetl ( fid );
    if ( text == -1 )
      error(['string $Nodes not found in file ',gmsh_file])
    end
    if strcmp(strtok(text),'$Nodes')
      break
    end
  end
  nq=fscanf(fid,'%d',1);
  R=fscanf(fid,'%d %f %f %f',[4,nq]);
  q=R([2:4],:);
   while ( 1 )
    text = fgetl ( fid );
    if ( text == -1 )
      error(['string $Elements not found in file ',gmsh_file])
    end
    if strcmp(strtok(text),'$Elements')
      break
    end
  end
  nelem=fscanf(fid,'%d\n',1);  % ne pas oublier \n sinon bug
  M=zeros(nelem,15);
  for i=1:nelem
    [V,N]=sscanf(fgetl(fid),'%d',Inf);
    M(i,1:N)=V;
  end
  I=find(sum(M)>0);
  M=M(:,I);
  J=find(M(:,2)==4);
  d=3;
  if isempty(J), d=2;end
  if d==3
    % tetrahedron
    tetra=M(J,:);
    Ltag_nbs=unique(tetra(:,3));
    nme=size(tetra,1);
    me=zeros(4,nme);
    for i=Ltag_nbs
      J=find(tetra(:,3)==i);
      me(:,J)=tetra(J,4+i:7+i)';
    end
    mel=tetra(J,4);
    clear tetra
    if(dim>d)
      q=[q;zeros(dim-d,size(q,2))];
    end
  end
  % triangle
  triangle=M(find(M(:,2)==2),:);
  Ltag_nbs=unique(triangle(:,3));
  ntri=size(triangle,1);
  tri=zeros(3,ntri);
  for i=Ltag_nbs
    J=find(triangle(:,3)==i);
    tri(:,J)=triangle(J,4+i:6+i)';
  end
  trilabel=triangle(J,4);
  if d==2
    q=q(1:2,:); % z==0!
    mel=trilabel;me=tri;nme=ntri;
    if(dim>d)
      q=[q;zeros(dim-d,size(q,2))];
    end
  else
    bel=trilabel;be=tri;nbe=ntri;
  end
  if d==2
    % line
    line=M(find(M(:,2)==1),:);
    Ltag_nbs=unique(line(:,3));
    nbe=size(line,1);
    be=zeros(2,nbe);
    for i=Ltag_nbs
      J=find(line(:,3)==i);
      be(:,J)=line(J,4+i:5+i)';
    end
    bel=line(J,4);
  end 
  Th=setMesh(dim,nq,nme,nbe,q,me,be,mel,bel,'name',gmsh_file,'format','gmsh','d',d);
  fclose(fid);
%end
