% PlotEdgeNumberfull.m
%  Demo of PlotEdgeNumber function
% PlotMesh, PlotBounds, PlotNodeNumber and PlotTriangleNumber are also used.
%  The mesh is provided by the meshes.tar.gz archive.
% The figure is included in the report to describe the mesh structure.
Th=GetMeshOpt('Ring-3.msh',2);
PlotMesh(Th,'RGBcolors', selectColors(length( unique(Th.bel))+1));
RGBcolors=PlotBounds(Th,'LineWidth',2);
PlotEdgeNumber(Th,'RGBEdgeColors', RGBcolors, 'Color',[0 0 0],'LineStyle','-', 'LineWidth',0.5,'FontSize',16);
PlotNodeNumber(Th,'Color',[0 0 1],'FontSize',16);
PlotTriangleNumber(Th,'Color',[1 0 0],'FontSize',16);
set(legend(),'FontSize',24);
if ~isOctave()
set(legend(),'Location','BestOutside');
end
