function PlotMesh(Th,varargin)
% function PlotMesh(Th,varargin)
%   Plotting a 2D or 3D mesh
%
% Parameters:
%   Th :  mesh structure
%
% Optional parameters (of type addParameter):
%   Color : (string) To define the color of mesh lines. Default value is the empty string.
%   RGBcolors : (array of doubles) Array of values to set RGB  values of the mesh lines.
%               Each region may be identified by a different RGB. Default value is the empty array.
%   LineWidth : (double) To set the line width of mesh lines. Default value is 0.5.
%   FaceAlpha : (integer) To set the transparency (only in 3D). 0 means no transparency.
%               Default value is 0.
%   labels : (array of integers). To plot only specific regions. Default value is the empty array.
%   Legend :  (bool) To display the legend or not. Default value is false.
%
%  Example:
%   Th=GetMeshOpt('meshes/disque4-1-20.msh');
%   PlotMesh(Th,'LineWidth',1.0)

%  @verbatim
%   Th=GetMeshOpt('meshes/disque4-1-20.msh');
%   PlotMesh(Th,'LineWidth',1.0) @endverbatim
%  \image html images/PlotMesh.jpg "figure : PlotMesh(Th,\'LineWidth\',1.0)"
%  \image latex images/PlotMesh.eps "My application" width=10cm

if ismember(Th.d,1:3)
    eval(sprintf('PlotMesh%dD(Th,varargin{:})',Th.d));
else
    error('Unknown mesh dimension. Unable to Plot');
end
