function RGBcolors=PlotBounds2D(varargin)
% function RGBcolors=PlotBounds2D(varargin)
%   To plot boundaries with labels for a 2D mesh
%
% parameters:
%   Th  : mesh structure
%   RGBcolors : (array of doubles) Array of values to set RGB values of boundaries. Each region may be identified by a different RGB. Default value is the empty array.
%   Color : (string) To define the color of mesh lines. Default value is the empty string.
%   LineWidth : (double) To set the line width of mesh lines. Default value is 2.
%   Legend :  (bool) To display the legend or not. Default value is true.
%   FontSize :  (integer) To set the font size of the legend. Default value is 10.
%   labels : (array of integers). To plot only specific regions. Default value is the empty array.

%
% Example:
%  @verbatim 
%   PlotBounds2D(Th,'LineWidth',2);@endverbatim
%  \image html images/PlotBounds.png "figure : PlotBounds2D(Th,\'LineWidth\',2);" 
%
p = inputParser; 
p=AddRequired(p,'Th', @isstruct);
p=AddParamValue(p,'RGBcolors', [], @isnumeric );
p=AddParamValue(p,'Color', '', @ischar );
p=AddParamValue(p,'LineWidth', 2.0 , @isnumeric );
p=AddParamValue(p,'Legend', true , @islogical );
p=AddParamValue(p,'FontSize', 10 , @isnumeric );
p=AddParamValue(p,'labels', [], @isnumeric ); % @(v) isempty(setdiff(v,unique(Th.bel)))
p=Parse(p,varargin{:});

R=p.Results;
Th=R.Th;

LB=unique(Th.bel);
if ~isempty(R.labels) 
  if isempty(setdiff(R.labels,LB))
    LB=R.labels;
  else
    error('Wrong labels');
  end
end
nLab=length(LB);
RGBcolors=ChooseColor(R,nLab);
PrevHold=SetHoldOn(true);
cLegend=cell(1,nLab);
%if isOctave(), label=@(i) sprintf('\\Gamma_{%d}',LB(i));else 
 label=@(i) sprintf('\\Gamma_{%d}',LB(i));
%end
LB=reshape(LB,1,nLab);
h=zeros(nLab,1);
if R.Legend
  
  for i=LB
    indx=find(LB==i);
    cLegend{indx}=label(indx);
    I=find(Th.bel == i);
    h(indx)=plot([Th.q(1,Th.be(1,I(1))) Th.q(1,Th.be(2,I(1)))], ...
              [Th.q(2,Th.be(1,I(1))) Th.q(2,Th.be(2,I(1)))]);
    set(h(indx),'Color',RGBcolors(indx,:),'LineWidth',R.LineWidth);
  end
  %eval(sprintf('H=legend(h,%s);',cLegend));
  H=legend(h,cLegend);
  set(H,'FontSize',R.FontSize);
end

% Then remaining boundaries
for i=LB
  indx=find(LB==i);
  I=find(Th.bel == i);
  for k=2:length(I)
    h=plot([Th.q(1,Th.be(1,I(k))) Th.q(1,Th.be(2,I(k)))], ...
           [Th.q(2,Th.be(1,I(k))) Th.q(2,Th.be(2,I(k)))]);
    set(h,'Color',RGBcolors(indx,:),'LineWidth',R.LineWidth);
  end
end
RestoreHold(PrevHold)
axis off
axis image
