function PlotBasisFunc(M,number)
% function PlotBasisFunc(M,number) 
%   To display a P1 basis function of a given vertex. The mesh structure and the vertex number are required. This function could be useful for debugging.
%
% parameters:
%   M  : mesh structure
%   number : (integer) node number for plotting basis function
%
% PlotNodeNumber and PlotTriangleNumber functions are used
%
% Example:
% M ='disque4-1-3.msh', number=17
% PlotBasisFunc(M,number)
%
view(3)
PlotMesh(M);
q=M.q;
me=M.me;
nt=size(me,2); % number of triangles
hold on
i=number;
for k=1:nt % triangle k is represented
  if ( ~ ismember(i,me(:,k) ) )
  plot([ q(1,me(1,k)) q(1,me(2,k)) q(1,me(3,k)),q(1,me(1,k))], ...
       [ q(2,me(1,k)) q(2,me(2,k)) q(2,me(3,k)),q(2,me(1,k))])
  else
    plot([ q(1,me(1,k)) q(1,me(2,k)) q(1,me(3,k)),q(1,me(1,k))], ...
       [ q(2,me(1,k)) q(2,me(2,k)) q(2,me(3,k)),q(2,me(1,k))],':')  
  end
end
axis equal

[I,K]=find( M.me == i);
n=length(K);
for j=1:n
   k=K(j);
   z=zeros(4,1);
   z(I(j))=1;
   if (I(j) == 1)
       z(4)=1;
   end
   plot3([ M.q(1,M.me(:,k)) M.q(1,M.me(1,k))],[ M.q(2,M.me(:,k)) M.q(2,M.me(1,k))],z,'r','LineWidth',2.0)
end
plot3([ M.q(1,i) M.q(1,i) ],[ M.q(2,i) M.q(2,i) ],[0 1],'r:')%,'LineWidth',2.0)
axis off
PlotNodeNumber(M)
PlotTriangleNumber(M)
title(['Representation of basis function number ',num2str(i)])
view(3)
%zoom(2.0)
