% PlotEdgeNumberfull.m
%  Demo of PlotEdgeNumberfull function
% PlotNodeNumber and PlotTriangleNumber are also used.
%  The mesh is provided by the meshes.tar.gz archive.
Th=mVisuMesh.mesh.GetMeshOpt('disque4-1-2.msh',2);
mVisuMesh.graphics.PlotMesh(Th,'RGBcolors', mVisuMesh.graphics.selectColors(length( unique(Th.bel))+1));
RGBcolors=mVisuMesh.graphics.PlotBounds(Th,'LineWidth',2);
mVisuMesh.graphics.PlotEdgeNumber(Th,'RGBEdgeColors', RGBcolors, 'Color',[0 0 0],'LineStyle','-', 'LineWidth',0.5,'FontSize',16);
mVisuMesh.graphics.PlotNodeNumber(Th,'Color',[0 0 1],'FontSize',16);
mVisuMesh.graphics.PlotTriangleNumber(Th,'Color',[1 0 0],'FontSize',16);
set(legend(),'FontSize',24);
if ~mVisuMesh.utils.isOctave()
set(legend(),'Location','BestOutside');
end
