function Th=GetMeshOpt(cFileName,dim,varargin)
% function Th=GetMeshOpt(cFileName,dim)
%   Definition of the mesh structure
%
% Parameters:
%  cFileName: mesh file name (string)
%  dim: space dimension (integer)
%
% Optional parameters (of type addParameter):
%  d: simplex dimension (integer)
%  format: mesh type (string). Only possible values are 'freefem' (default), 'gmsh', 'medit', 'triangle'.
%
% Return values:
%  Th: mesh structure. See the report
%
% Example:
% Th=mVisuMesh.mesh.GetMeshOpt('disk4-1-50.msh',2);
%
  p = inputParser; 
  p=mVisuMesh.utils.AddParamValue(p,'d', dim, @(v) v<=dim ); % condition à vérifier: d<= dim
  p=mVisuMesh.utils.AddParamValue(p,'format', 'freefem', @(v) ismember(v,{'freefem','triangle','gmsh','medit'}) );
  p=mVisuMesh.utils.Parse(p,varargin{:});
  R=p.Results;
  d=R.d;
  cFileName=checkfile(cFileName,R.format);
  switch d
    case 2
      Th=GetMesh2DOpt(cFileName,'dim',dim,'format',R.format);
    case 3
      Th=GetMesh3DOpt(cFileName,'dim',dim,'format',R.format);
    otherwise
      error('Wrong value for simplex dimension. Stop');
  end
end

function cfile=checkfile(cfile,format)
  if strcmp(format,'triangle')
    if checktriangle(cfile);return;end
    [Dir,~,~] = fileparts(cfile);
    if ~isempty(Dir)
      error('Unable to find Triangle mesh files:\n  %s [.node .ele .poly]\n',cfile);
    end
    mFile=mfilename('fullpath');
    idx=strfind(mFile,filesep);
    cfile=[mFile(1:idx(end-1)),'meshes',filesep,cfile];
    if ~checktriangle(cfile)
      error('Unable to find Triangle mesh files:\n  %s [.node .ele .poly]\n',cfile);
    end
  else
    fid=fopen(cfile,'r');
    if (fid~=-1),fclose(fid);return;end
    [Dir,~,~] = fileparts(cfile);
    if ~isempty(Dir)
      error('Unable to find mesh file:\n  %s\n',cfile);
    end
    mFile=mfilename('fullpath');
    idx=strfind(mFile,filesep);
    cfile=[mFile(1:idx(end-1)),'meshes',filesep,cfile];
    fid=fopen(cfile,'r');
    if fid==-1
      error('Unable to find mesh file:\n  %s\n',cfile);
    end
    fclose(fid);
  end
end

function isOk=checktriangle(cfile)
  isOk=false;
  for ext={'.node','.ele','.poly'}
    tfile=[cfile,ext{1}];
    fid=fopen(tfile,'r');
    if (fid~=-1), fclose(fid);else return; end
  end
  isOk=true;
end