function h=GetMaxLengthEdges(q,me)
%  Computation of the maximum edge length for a mesh defined by
%  arrays q and me. Useful to define the mesh step size.
%
%
% Parameters:
%  q: Array of vertices coordinates, `d\times\nq` array
%  (double). <br/>
%  `{\q}(\il,j)` is the
%  `\il`-th coordinate of the `j`-th vertex, `\il\in\{1,d\}` and
%  `j\in\ENS{1}{\nq}`
%  me: Connectivity array, `d+1\times\nme` array ('int32'). <br/>
%  `\me(\jl,k)` is the storage index of the
%  `\jl`-th  vertex of the `k`-th triangle in the array `\q` of
%  vertices coordinates, `\jl\in\{1,2,3\}` and
%       `k\in{\ENS{1}{\nme}}`.
% 
% Return values:
%  h: maximum edge length in the mesh
%

  ne=size(me,1);
  h=0;
  for i=1:ne
    for j=i+1:ne
      h=max(h,max(sum((q(:,me(i,:))-q(:,me(j,:))).^2,1)));
    end
  end
  h=sqrt(h);
end