% PlotIsolines_disk4.m
%  Demo of PlotIsolines function for a 2D mesh
%  trisurf function is also used.
%  The mesh is provided by the meshes.tar.gz archive.
Th=mVisuMesh.mesh.GetMeshOpt('disk4-1-50.msh',2);
x=Th.q(1,:);y=Th.q(2,:);
u=2+cos(pi*(x.^2+y.^2));
trisurf(Th.me',Th.q(1,:),Th.q(2,:),u);
mVisuMesh.graphics.PlotIsolines(Th,u,'plan',true);
if mVisuMesh.utils.isOctave(); axis([-1 1 -1 1 -0.1 3.1]);end;
if ~mVisuMesh.utils.isOctave()
set(legend(),'FontSize',24);
  set(legend(),'Location','BestOutside');
set(colorbar(),'Fontsize',13);
end
