function  varargout=Plot3DSurfIsolines(Th,U,varargin)
% function h=Plot3DSurfIsolines(Th,U,varargin)
%   To plot surface isolines in 3D
%
% parameters:
%   Th  : mesh structure
%   U : array of doubles of size Th.nq
%
% Optional parameters (of type addParameter):
%   niso: (integer) number of isolines. Default is 10
%   colormap : (string) To set colormap value to \'jet\', \'hsv\', \'gray\',
%   \'colorcube\',\'cool\',\'spring\',\'summer\',..  Default value is 'jet'.
%   colorbar : (bool) To set colorbar visible or not. Default is fals
%   labels : (array of integers). To plot isolines only on specific boundaries. Default value is the empty array.
%   PlotOptions : (cell) Plotting options. Default value is an empty cell.
%   isorange: array of integers which defines the range of isoline
%   values. Default value is an empty array and niso isoline values
%   are set in proportion in the range of minimum and maximum
%   values.
%
% Optional outputs:
% varargout{1} is the array of RGB colors used by the plot, varargout{2} is the array of isoline values.

  % PlotOptions={'Color','w','LineWidth',2}
  AllLabs=unique(Th.bel);
  p = inputParser;
  p=mVisuMesh.utils.AddParamValue(p,'niso',10,@isscalar);
  p=mVisuMesh.utils.AddParamValue(p,'colormap','jet',@ischar);
  p=mVisuMesh.utils.AddParamValue(p,'colorbar',false,@islogical);
%  p=AddParamValue(p,'color',[]); % unique color %interet (GS)?
  p=mVisuMesh.utils.AddParamValue(p,'labels',AllLabs,@isnumeric);
  p=mVisuMesh.utils.AddParamValue(p,'PlotOptions',{},@iscell);
  p=mVisuMesh.utils.AddParamValue(p,'isorange',[]);
  p=mVisuMesh.utils.Parse(p,varargin{:});
  
  R=p.Results;
  labels=intersect(R.labels,AllLabs); % to do : make tests + warning
  if (isempty(R.isorange) && R.niso>1), R.isorange=linspace(min(U),max(U),R.niso);end
  R.niso=length(R.isorange); 
  if size(U,1)==1, U=U';end
  
  if isempty(R.colormap)
    colors = mVisuMesh.graphics.selectColors(R.niso);
  else
    cmap=colormap(R.colormap);
    t=0:1/(R.niso-1):1;
    colors = RGB(t,cmap);
  end
  
  hold on
  axis equal
  
  for l=1:length(labels)
    J=find(Th.bel==labels(l));
  
    [LS,LD,I] = isolines(Th.q',Th.be(:,J)',U,R.isorange);
    for i=1:R.niso
      II=find(I==i);
    % Correctif Bug d'affichage avec plot => plot3
%plotval & plotisolines() a tester sur 2015a - ce qui suit est une
%alternative
      plot3([LS(II,1) LD(II,1)]',[LS(II,2) LD(II,2)]',[LS(II,3) LD(II,3)]','color',colors(i,:),R.PlotOptions{:});
    end
  end
  if R.colorbar
    if isOctave()
      caxis([R.isorange(1), R.isorange(end)])
      colorbar
    else
      colorbarIso(colors,R.isorange)
    end
  end
  if nargout>=1, varargout{1}=colors;end
  if nargout==2, varargout{2}=R.isorange;end
end
