function PlotNodeNumber(varargin)
% PlotNodeNumber(varargin)
%   To display node numbers in a mesh
%
% Parameters:
%   Th  : mesh structure
%
% Optional parameters (of type addParameter):
%   BackgroundColor : array of RGB values to set the background color. Default value is [1 1 1] (white).
%   FontSize :  (integer) To set the font size of node numbers. Default value is 10.
%   Color :  (array of doubles) To set RGB value of the number color. Default value is [0 0 0] (black).
%  C :  (integer) shift for node numbering (equal to 0 or
%  1). Default value is 0. If C=0, node numbering goes from 1 to
%  Th.nq else from 0 to Th.nq-1.
%
% Example:
%   Th=mVisuMesh.mesh.GetMeshOpt('meshes/disque4-1-3.msh');
%   mVisuMesh.graphics.PlotNodeNumber(Th);

%
% Example:
%  @verbatim 
%   mVisuMesh.graphics.PlotNodeNumber(Th,'Color',[1 0 0]);@endverbatim
%
% See also:
% 
p = inputParser; 
p=mVisuMesh.utils.AddRequired(p,'Th', @isstruct);
%  
p=mVisuMesh.utils.AddParamValue(p,'BackgroundColor', [1 1 1], @isnumeric );
p=mVisuMesh.utils.AddParamValue(p,'FontSize', 10, @isnumeric );
p=mVisuMesh.utils.AddParamValue(p,'Color', [0 0 0] , @isnumeric );
p=mVisuMesh.utils.AddParamValue(p,'C', 0 , @isnumeric ); % decalage indice 0 ou 1 (on soustrait C)
p=mVisuMesh.utils.Parse(p,varargin{:});

C=p.Results.C;
q=p.Results.Th.q;
nq=p.Results.Th.nq;
PrevHold=SetHoldOn(true);
text(q(1,:),q(2,:),num2str([1:nq]'-C), ...
     'BackgroundColor',p.Results.BackgroundColor, ...
     'Color',p.Results.Color, ...
     'FontSize',p.Results.FontSize, ...
     'HorizontalAlignment','center');
RestoreHold(PrevHold)