function RGBcolors=ChooseColor(R,nLab)
% function RGBcolors=ChooseColor(R,nLab)
% To create an array of RGB colors of size nLab.
%
% parameters: 
%  R:  inputParser containing RGBcolors and Color
%  nLab: (integer) either the number of boundaries or number of
%  subdomains (inside regions)
%
% Output: 
% RGBcolors: array of RGB colors of size nlab
%

%
% 4 cases:
% - Both RGBColors and Color are empty -> RGBcolors wins (call to selectColors)
% - RGBColors is nonempty and Color is empty -> RGBColors wins
% - RGBColors is empty and Color is nonempty -> Color wins
% - Both RGBColors and Color are nonempty -> Color wins

if (isempty(R.RGBcolors))
  if(isempty(R.Color))
  RGBcolors = mVisuMesh.graphics.selectColors(nLab);
  else
    if(length(R.Color)==1),R.Color=spec2col(R.Color);end;
    RGBcolors = ones(nLab,1)*svg2rgb(R.Color);
  end
else
  if(isempty(R.Color))
  RGBcolors=R.RGBcolors;
  if (size(RGBcolors,2)~=3) || (size(RGBcolors,1)<nLab)
    warning('RGBcolors dimension failed. Using default.')
    RGBcolors = mVisuMesh.graphics.selectColors(nLab);
  end
  else
    if(length(R.Color)==1),R.Color=spec2col(R.Color);end;
    RGBcolors = ones(nLab,1)*svg2rgb(R.Color);
  end
end
end
