function PlotMesh3D(Th,varargin)
% function PlotMesh3D(Th,varargin)
%   Plotting a 3D mesh
%
% Parameters:
%   Th :  mesh structure
%
% Optional parameters (of type addParameter):
%   Color : (string) To define the color of mesh lines. Default value is the empty string.
%   RGBcolors : (array of doubles) Array of values to set RGB  values of the mesh lines.
%               Each region may be identified by a different RGB. Default value is the empty array.
%   LineWidth : (double) To set the line width of mesh lines. Default value is 0.5.
%   FaceAlpha : (integer) To set the transparency (only in 3D). 0 means no transparency.
%               Default value is 0.
%   labels : (array of integers). To plot only specific regions. Default value is the empty array.
%   Legend :  (bool) To display the legend or not. Default value is false.
%
% Example:
%   Th=mVisuMesh.mesh.GetMeshOpt('cube6-1-3.mesh',3);
%   mVisuMesh.graphics.PlotMesh3D(Th,'LineWidth',1.0)
%

%  @verbatim
%   Th=mVisuMesh.mesh.GetMeshOpt('meshes/cube-3.mesh',3);
%   mVisuMesh.graphics.PlotMesh3D(Th,'LineWidth',1.0) @endverbatim
%  \image html images/PlotMesh.jpg "figure : mVisuMesh.graphics.PlotMesh3D(Th,\'LineWidth\',1.0)"
%  \image latex images/PlotMesh.eps "My application" width=10cm

p = inputParser;
%p=mVisuMesh.utils.AddParamValue(p,'Color', [0 0 1], @isnumeric );
p=mVisuMesh.utils.AddParamValue(p,'Color', '', @ischar );
p=mVisuMesh.utils.AddParamValue(p,'RGBcolors', [], @isnumeric );
p=mVisuMesh.utils.AddParamValue(p,'LineWidth', 0.5 , @isnumeric );
p=mVisuMesh.utils.AddParamValue(p,'FaceAlpha', 0 , @isnumeric );
%p=mVisuMesh.utils.AddParamValue(p,'EdgeColor', [0 0 1] , @isnumeric );
p=mVisuMesh.utils.AddParamValue(p,'labels', [], @isnumeric ); % @(v) isempty(setdiff(v,unique(Th.mel)))
p=mVisuMesh.utils.AddParamValue(p,'Legend', false, @islogical);
p=mVisuMesh.utils.Parse(p,varargin{:});
R=p.Results;
PrevHold=SetHoldOn(true);
%  I1=[1:4,1,3];
%  I2=[2,4];
%  for k=1:Th.nme
%    plot3(Th.q(1,Th.me(I1,k)),Th.q(2,Th.me(I1,k)),Th.q(3,Th.me(I1,k)),'Color',p.Results.Color);
%    plot3(Th.q(1,Th.me(I2,k)),Th.q(2,Th.me(I2,k)),Th.q(3,Th.me(I2,k)),'Color',p.Results.Color);
%  end
ListSubDomLabel=unique(Th.mel);
if ~isempty(R.labels)
    if isempty(setdiff(R.labels,ListSubDomLabel))
        ListSubDomLabel=R.labels;
    else
        error('Wrong labels');
    end
end
nSubDom=length(ListSubDomLabel);
RGBcolors=ChooseColor(R,nSubDom);
cLegend=cell(1,nSubDom);
H=cell(1,nSubDom);
ListSubDomLabel=reshape(ListSubDomLabel,1,nSubDom);
if mVisuMesh.utils.isOctave()
    options={'interpreter','tex','fontsize',12};
else
    options={'interpreter','latex','fontsize',12};
end
for i=ListSubDomLabel
    I=find(Th.mel==i);
    indx=find(ListSubDomLabel==i);
    if mVisuMesh.utils.isOctave()
        T=Th.me(:,I)';
        triang = [T(:, 1) T(:, 2) T(:, 3); ...
            T(:, 2) T(:, 3) T(:, 4); ...
            T(:, 3) T(:, 4) T(:, 1); ...
            T(:, 4) T(:, 1) T(:, 2)];
        H{indx}=patch('faces',triang,'vertices',Th.q','FaceColor',RGBcolors(indx,:),'FaceAlpha', ...
            R.FaceAlpha,'EdgeColor',RGBcolors(indx,:),'LineWidth',p.Results.LineWidth);
    else
        h=tetramesh(Th.me(:,I)',Th.q','FaceColor',RGBcolors(indx,:),'FaceAlpha', ...
            R.FaceAlpha,'EdgeColor',RGBcolors(indx,:));
        H{indx}=h(1);
    end
    if mVisuMesh.utils.isOctave()
        cLegend{indx}=sprintf('\\Omega_{%d}',i);
    else
        cLegend{indx}=sprintf('$\\Omega_{%d}$',i);
    end
end
%Edges=[Th.me([1 2],:),Th.me([1 3],:),Th.me([1 4],:),Th.me([1 4],:),Th.me([2 3],:),Th.me([2 4],:),Th.me([3 4],:)];
%Edges=unique(sort(Edges,1)','rows');
%Ne=length(Edges);
%for k=1:Ne
%  plot3(Th.q(1,Edges(k,:)),Th.q(2,Edges(k,:)),Th.q(3,Edges(k,:)),'Color',p.Results.Color);
%end

%options={'interpreter','latex','fontsize',12};
if R.Legend %&& ~mVisuMesh.utils.isOctave()
  h=legend(cell2mat(H),cLegend);
    set(h,options{:});
    %  legend(cLegend,options{:})
end
RestoreHold(PrevHold)
axis off
axis equal
view(3)
