function PrintMesh(Th,varargin)
% function PrintMesh(Th,varargin)
% To print main statistics of the mesh
%
% Example:
% Th=GetMeshOpt('disk4-1-50.msh',2);
% PrintMesh(Th);
%
if nargin==1,cFileName='';else,cFileName=varargin{1};end;
if isfield(Th,'info')
    name=Th.info.name;
    format=Th.info.format;
else
    name='unknown';
    format='unknown';
end
if isfield(Th,'h')
    h=Th.h;
else
    h=mVisuMesh.mesh.GetMaxLengthEdges(Th.q,Th.me);
end
if isfield(Th,'hmin')
    hmin=Th.hmin;
else
    hmin=mVisuMesh.mesh.GetMinLengthEdges(Th.q,Th.me);
end
%fprintf('%s - dim=%d, d=%d, nq=%d, nme=%d, nbe=%d, h=%f, hmin=%f, format=%s\n',name,Th.dim,Th.d,Th.nq,Th.nme,Th.nbe,h,hmin,format);
if isempty(cFileName)
fprintf('---------------\nMesh: %s\ndim=%d, d=%d, format=%s\nnq=%d, nme=%d, nbe=%d\nhmax=%f, hmin=%f\n---------------\n',name,Th.dim,Th.d,format,Th.nq,Th.nme,Th.nbe,h,hmin);
else
fp=fopen(cFileName,'w');
fprintf(fp,'---------------\nMesh: %s\ndim=%d, d=%d, format=%s\nnq=%d, nme=%d, nbe=%d\nhmax=%f, hmin=%f\n---------------\n',name,Th.dim,Th.d,format,Th.nq,Th.nme,Th.nbe,h,hmin);
fclose(fp);
end
