function PlotMesh2D(Th,varargin)
% function PlotMesh2D(Th,varargin)
%   Plotting a 2D mesh
%
% Parameters:
%   Th :  mesh structure
%
% Optional parameters (of type addParameter):
%   LineWidth : (double) To set the line width of mesh lines. Default value is 0.5.
%   RGBcolors : (array of doubles) Array of values to set RGB  values of the mesh lines.
%               Each region may be identified by a different RGB. Default value is the empty array.
%   Color : (string) To define the color of mesh lines. Default value is the empty string.
%   labels : (array of integers). To plot only specific regions. Default value is the empty array.
%   Legend :  (bool) To display the legend or not. Default value is true.
%
% Example:
%   Th=mVisuMesh.mesh.GetMeshOpt('disque4-1-20.msh',2);
%   mVisuMesh.graphics.PlotMesh2D(Th,'LineWidth',1.0)
%

%  @verbatim
%   Th=mVisuMesh.mesh.GetMeshOpt('meshes/disque4-1-20.msh',2);
%   mVisuMesh.graphics.PlotMesh2D(Th,'LineWidth',1.0) @endverbatim
%  \image html images/PlotMesh.jpg "figure : mVisuMesh.graphics.PlotMesh2D(Th,\'LineWidth\',1.0)"
%  \image latex images/PlotMesh.eps "My application" width=10cm
 
p = inputParser;
%p=mVisuMesh.utils.AddRequired(p,'Th', @isstruct);
%
%p=mVisuMesh.utils.AddParamValue(p,'Color', [0 0 1], @isnumeric );
p=mVisuMesh.utils.AddParamValue(p,'LineWidth', 0.5 , @isnumeric );
p=mVisuMesh.utils.AddParamValue(p,'RGBcolors', [], @isnumeric );
p=mVisuMesh.utils.AddParamValue(p,'Color', '', @ischar );
p=mVisuMesh.utils.AddParamValue(p,'labels', [], @isnumeric ); % @(v) isempty(setdiff(v,unique(Th.mel)))
p=mVisuMesh.utils.AddParamValue(p,'Legend', false, @islogical);
p=mVisuMesh.utils.Parse(p,varargin{:});
R=p.Results;
PrevHold=SetHoldOn(true);
ListSubDomLabel=unique(Th.mel);
if ~isempty(R.labels)
    if isempty(setdiff(R.labels,ListSubDomLabel))
        ListSubDomLabel=R.labels;
    else
        error('Wrong labels');
    end
end
nSubDom=length(ListSubDomLabel);
RGBcolors=ChooseColor(R,nSubDom);
cLegend=cell(1,nSubDom);
if size(ListSubDomLabel,2)==1, ListSubDomLabel=ListSubDomLabel';end;
if mVisuMesh.utils.isOctave()
    options={'interpreter','tex','fontsize',12};
else
    options={'interpreter','latex','fontsize',12};
end
for i=ListSubDomLabel
    I=find(Th.mel==i);
    indx=find(ListSubDomLabel==i);
    triplot(Th.me(:,I)',Th.q(1,:),Th.q(2,:),'Color',RGBcolors(indx,:),'LineWidth',R.LineWidth);
    if mVisuMesh.utils.isOctave()
        cLegend{indx}=sprintf('\\Omega_{%d}',i);
    else
        cLegend{indx}=sprintf('$\\Omega_{%d}$',i);
    end
end

if R.Legend %&& ~mVisuMesh.utils.isOctave()
    %if nSubDom>1, legend(cLegend,options{:}); end
    %cLegend
    %options
    h=legend(cLegend);
    set(h,options{:});
end
RestoreHold(PrevHold)
axis off
axis image
