function Mesh=GetMesh2DOpt(cFileName,varargin)
% Mesh=GetMesh2DOpt(cFileName)
%   Reading a 2D-mesh
%
% Parameter :
%   cFileName : mesh filename 
% Output :
%   Mesh, a mesh structure (see setMesh.m)
% Mesh=mVisuMesh.mesh.GetMesh2DOpt(cFileName,varargin)
%   Reading a 2D-mesh in format :
%     - FreeFem++, 
%     - medit,
%     - gmsh.
%
% Parameter :
%   cFileName : mesh filename 
% Optional parameter :
%   'format' : 'freefem' (default) or 'gmsh'
%   'dim'    : 2 (default) - integer
% Output :
%   Mesh, a mesh structure (see setMesh.m)
%
  p = inputParser; 
  p=mVisuMesh.utils.AddParamValue(p,'format', 'freefem', @(v) ismember(v,{'freefem','triangle','gmsh','medit'}) );
  p=mVisuMesh.utils.AddParamValue(p,'dim', 2, @isfloat );
  p=mVisuMesh.utils.Parse(p,varargin{:});

  R=p.Results;
  Format=R.format;
  dim=R.dim;

  [~,~,ext]=fileparts(cFileName);
  if strcmp(ext,'.mesh') && strcmp(Format,'freefem')
    warning('For a 2D freefem mesh, file extension should be .msh !!');
  end

  % FC -> a ameliorer avec une liste des formats dispo et 
  %       utilisation + generique GetMesh%s...
  switch Format
   case('medit')
    Mesh=GetMeshMedit(cFileName,'dim',dim);
   case('gmsh')
% 09/15: il vaut mieux utiliser gmsh2mesh et gmsh2mesh_octave plutot que GetGmshMesh
%
% ancienne version
%    Mesh=GetGmshMesh(cFileName);
     if mVisuMesh.utils.isOctave()
       Mesh=gmsh2mesh_octave(cFileName,'dim',dim);
     else
       Mesh=gmsh2mesh(cFileName,'dim',dim);
     end
   case('freefem')
    Mesh=GetFreefem2DMesh(cFileName,'dim',dim);
    case('triangle')
     Mesh=Get_triangle(cFileName,'dim',dim);
   otherwise
     error('Unexpected mesh type');
 end
  
 if Mesh.nq==0 || Mesh.nme==0
   warning('nq or nme is zero! Maybe mesh reading is wrong!');
  end
end


