%
% Définir la structure info d'un maillage
%
% contient pour le moment le nom court (relatif) du fichier, son format
% ('freefem','medit', 'gmsh','triangle' ...)
% On pourrait éventuellement ajouter le nom absolu, la taille du
% fichier
%
%
function Th=setMeshInfo(Th,varargin)
p = inputParser; 
p=mVisuMesh.utils.AddParamValue(p,'name', '', @ischar ); % relative name of the
					 % mesh file
p=mVisuMesh.utils.AddParamValue(p,'format', '', @ischar ); % It could be: gmsh, medit,
					 % gmsh2medit, hypercube, ....
p=mVisuMesh.utils.Parse(p,varargin{:});
MeshName=GetMeshName(p.Results.name);
MeshFormat=p.Results.format;
Th.info=struct('name',MeshName,'format',MeshFormat);
end

%
% Récupérer le nom du maillage (=nom relatif) à partir du chemin
% (nom absolu)
%
function MeshName=GetMeshName(fname)
[~,b,c]=fileparts(fname);
MeshName=[b,c];
end
