function C=svg2rgb(name)
% function C=svg2rgb(name)
% This function converts a color name to an RGB triplet.
% See https://www.w3.org/TR/SVG11/types.html#ColorKeywords

  [svgname,svgcolor]=svg();
  name = lower(name);
  k = find(strcmpi(svgname, lower(name)));
  if isempty(k)
    error('Unable to find color %s!',name)
  end
  C=svgcolor{k};
end