function Plot3DSurfVal(Th,x,varargin)
% function Plot3DSurfVal(Th,x,varargin)
% To display fields corresponding to nodal variables on the surface of a 3D mesh.
%
% parameters:
%   Th  : mesh structure
%   x : `3\times\nq` array of doubles of size Th.nq
%   colormap : To set colormap value to \'jet\', \'hsv\', \'gray\',
%   \'colorcube\',\'cool\',\'spring\',\'summer\',..  Default value is 'jet'.
%   colorbar : To set colorbar visible if true. Default value is true
%   labels:  array of labels (integer) to plot only specific regions. 
%   PlotOptions : (cell) Plotting options. Default value is an empty cell.

  AllLabs=unique(Th.bel);
  p = inputParser;
  p=AddParamValue(p,'colormap','jet',@ischar);
  p=AddParamValue(p,'colorbar',true,@islogical);
  p=AddParamValue(p,'labels',AllLabs,@isnumeric);
  p=AddParamValue(p,'PlotOptions', {} , @iscell );
  p=Parse(p,varargin{:});

  R=p.Results;
  labels=intersect(R.labels,AllLabs); % to do : make tests + warning
  
  view(3)
  colormap(R.colormap);
  for i=1:length(labels)
    I=find(Th.bel==labels(i));
    if isOctave
      patch('Vertices',Th.q','Faces',Th.be(:,I)','facevertexcdata',x','FaceColor','interp',R.PlotOptions{:})
    else
      patch('Vertices',Th.q','Faces',Th.be(:,I)','CData',x,'FaceColor','interp',R.PlotOptions{:})
    end
  end
  if R.colorbar
   colorbar
  end
  axis equal
  axis off
end
