function InitmVisuMesh()
logv=ver;
isOct=strcmp(logv(1).Name,'Octave');
if isOct
    pkg load general;
    more off
    pkg load msh
    warning('off','Octave:fopen-file-in-path') % disable warning for mesh files in path
end
upath=strrep(userpath,':','');%upath=userpath;
if ~verLessThan('matlab','9.0') % version >= 2016a
    P=[upath,filesep,'Add-Ons/Toolboxes/mVisuMesh/code'];
elseif ~verLessThan('matlab','8.4') % version >= 2014b
    P=[upath,filesep,'Toolboxes/mVisuMesh'];
else
    warning('Matlab R2014b at least needed using the .mltbx file');
end
addpath(P);
addpath([P,filesep,'base']);
addpath([P,filesep,'graphics']);
addpath([P,filesep,'CompMatOct']);
addpath([P,filesep,'readMesh']);
addpath([P,filesep,'export']);
addpath([P,filesep,'demos']);
v=visuMesh_version();
fprintf('Init of Matlab mVisuMesh toolbox - version %s\n',v);
disp('---------------------------------------------------------');
