% vtkWrite_2dvectfield
%  Demo of vtkWrite function for a 2D gmsh mesh
%  The vtk file contains the mesh and a vector field.
%  The mesh is provided by the meshes.tar.gz archive.
Th=GetMeshOpt('magnetism.msh',2, 'format','gmsh');
U=cell(2,1);U{1}=Th.q(1,:).^2+Th.q(2,:).^2;
U{2}=cos(U{1});
vtkWrite('magnetism-v.vtk',Th, {[U{1}',U{2}']},{'U'});