% PlotVal_disk4.m
%  Demo of PlotVal function for a 2D mesh
%  colormap option is used for PlotVal.
%  The mesh is provided by the meshes.tar.gz archive.
Th=GetMeshOpt('disk4-1-50.msh',2);
x=Th.q(1,:);y=Th.q(2,:);
u=2+cos(pi*(x.^2+y.^2));
PlotVal(Th,u,'colormap','cool');
set(legend(),'FontSize',24);
if ~isOctave()
h=set(legend,'Location','BestOutside');
set(colorbar(),'FontSize',22);
end
