% PlotIsolines_disk4_Options1.m
%  Demo of PlotIsolines function for a 2D mesh
%  Several options are used: colorbar, PlotOptions ad colormap.
%  The mesh is provided by the meshes.tar.gz archive.
Th=mVisuMesh.mesh.GetMeshOpt('disk4-1-50.msh',2);
x=Th.q(1,:);y=Th.q(2,:);
u=2+cos(pi*(x.^2+y.^2));
[colors,values]=mVisuMesh.graphics.PlotIsolines(Th,u, 'colorbar',true,'PlotOptions', {'linewidth',2},'colormap','cool');
if ~mVisuMesh.utils.isOctave()
set(legend(),'FontSize',24);
h=set(legend,'Location','BestOutside');
end
