% script de base (de non regression) de lecture des maillages issus de
% FreeFem 2D et 3D et de gmsh
%
% On teste ici les fonctions GetMesh, PlotMesh, PlotBounds, PlotVal
% et vtkWrite.
% A compléter et améliorer
%
% - La fonction locale statsMesh lit le maillage (GetMesh*) et
% affiche ses stats (PrintMesh)
%
% - La fonction locale testPlot appelle a la fois PlotMesh,
% PlotBounds et PlotVal (2D), PlotMeshet PlotBounds, Plot3DSurfVal (3D)
%
%
function visumesh_demo()
%InitMeshToolbox;
%mVisuMesh.init;
import mVisuMesh.utils.isOctave
import mVisuMesh.mesh.GetMeshOpt
import mVisuMesh.export.vtkWrite

fprintf('\nTests of PlotMesh, PlotBounds, PlotVal and Plot3DSurfVal\n');
fprintf('------------------------------------------------------------\n');
%[dirout,meshdir2d,meshdir3d]=getDirectories();

%
% 2D FreeFem
%
%cFileName=[meshdir2d,filesep,'disk4-1-50.msh'];
cFileName='disk4-1-50.msh';
Th=statsMesh(cFileName,2);
testPlot(Th);
%
% 2D gmsh
%
cFileName='magnetism.msh';
Th=statsMesh(cFileName,2,'format','gmsh');
testPlot(Th);
%
% 2D triangle
%
cFileName='box.1';
Th=statsMesh(cFileName,2,'format','triangle');
testPlot(Th);
%
% 3D FreeFem
%
cFileName='cube6-1-3.mesh';
Th=statsMesh(cFileName,3);
testPlot(Th);
%
% 3D gmsh - too long with Octave
%
if ~isOctave()
    %    cFileName=[meshdir3d,filesep,'sphere-1-3.mesh'];
    cFileName='sphere-1-3.mesh';
    %Th=statsMesh([path3Dmesh,filesep,'sphere-1-3.mesh'],3,'format','medit');
    Th=statsMesh(cFileName,3,'format','medit');
    testPlot(Th);
end


%cFileName=[meshdir3d,filesep,'sphere8-4.msh'];
cFileName='sphere8-4.msh';
%Th=statsMesh([path3Dmesh,filesep,'sphere-1-3.mesh'],3,'format','medit');
Th=statsMesh(cFileName,3,'format','gmsh');
testPlot(Th);

cFileName='disk4-1-50.msh';
Th=statsMesh(cFileName,2);
testPlot(Th);



% VTK
fprintf('Tests of vtkWrite for vtk outputs\n');
fprintf('------------------------------------------------------------\n');
clear Th;
Th=GetMeshOpt('magnetism.msh',2,'format','gmsh');
fprintf('vtkWrite to save only the mesh for %s\n',Th.info.name);
vtkWrite('magnetism.vtk',Th,'','');
U=cos(Th.q(1,:).^2+Th.q(2,:).^2);
fprintf('vtkWrite to save a scalar field for %s\n',Th.info.name);
vtkWrite('magnetism-s.vtk',Th,{U'},{'u'});
clear U;
U{1}=Th.q(1,:).^2+Th.q(2,:).^2;
U{2}=cos(U{1});
fprintf('vtkWrite to save a vector field for %s\n',Th.info.name);
vtkWrite('magnetism-v.vtk',Th,{[U{1}',U{2}']},{'U'});
clear Th U;
%cFileName=[meshdir3d,filesep,'sphere8-4.msh'];
cFileName='sphere8-4.msh';
Th=GetMeshOpt(cFileName,3,'format','gmsh');
fprintf('\nvtkWrite to save only the mesh for %s\n',Th.info.name);
vtkWrite('sphere8-4.vtk',Th,'','');
U=cos(Th.q(1,:).^2+Th.q(2,:).^2+Th.q(3,:).^2);
V=cos(Th.q(1,:).^2+Th.q(2,:).^2+Th.q(3,:).^2);
fprintf('vtkWrite to save a scalar field for %s\n',Th.info.name);
vtkWrite('sphere8-4-s.vtk',Th,{U',V'},{'u','v'});
clear U;
U{1}=Th.q(1,:).^2+Th.q(2,:).^2+Th.q(3,:).^2;
U{2}=cos(U{1});
U{3}=sin(U{1});
fprintf('vtkWrite to save a vector field for %s\n',Th.info.name);
vtkWrite('sphere8-4-v.vtk',Th,{[U{1}',U{2}',U{3}']},{'U'});
end

% To read a mesh and to display statistics of it
%
% Example:
%% FreeFEM example
%  statsMesh('cube6-1-3.mesh',3,'format','medit');
%% GMSH example
%  statsMesh('magnetism.msh',2,'format','gmsh');
%
function Th=statsMesh(varargin)
import mVisuMesh.utils.*
import mVisuMesh.mesh.*
p = inputParser;
p=AddRequired(p,'cFileName', @ischar);
p=AddRequired(p,'d', @isnumeric);
%
p=AddParamValue(p,'format', 'freefem', @ischar );
p=Parse(p,varargin{:});

R=p.Results;

%switch R.format
%    case 'freefem'
%        fprintf('%s is a %dD FreeFEM mesh\n',R.cFileName,R.d);
%    case 'gmsh'
%        fprintf('%s is a %dD GMSH mesh\n',R.cFileName,R.d);
%end
Th=GetMeshOpt(R.cFileName,R.d,'format',R.format);
PrintMesh(Th);
end

%
% Fonction locale qui appelle a la fois PlotMesh, PlotBounds et
% PlotVal (si 2D), PlotNodeNumber, PlotTriangleNumber, PlotBasisFunc (si 2D et maillage grossier), seulement PlotMesh3D et PlotBounds3D (si 3D)
%
function testPlot(varargin)
import mVisuMesh.utils.*
import mVisuMesh.graphics.
p = inputParser;
tpause=6;
p=AddRequired(p,'Th', @isstruct);
%
p=AddParamValue(p,'u', @(x,y) x+y, @isfhandle );
p=Parse(p,varargin{:});
Th=p.Results.Th;

switch Th.d
    case 2
        u=@(x,y) x.*y.^2;
    case 3
        u=@(x,y,z) x.*y.^2+z;
end

fprintf('PlotMesh for %s\n',Th.info.name);
PlotMesh(Th);
pause(tpause);close;
fprintf('PlotBounds for %s\n',Th.info.name);
PlotBounds(Th);
pause(tpause);close;

if (Th.d==2)
    fprintf('PlotVal for %s\n',Th.info.name);
    PlotVal(Th,u(Th.q(1,:),Th.q(2,:)));
else
    fprintf('Plot3DSurfVal for %s\n',Th.info.name);
    Plot3DSurfVal(Th,u(Th.q(1,:),Th.q(2,:),Th.q(3,:)));
end
pause(tpause);close;

if (Th.d==2) && (Th.nq<100)
    fprintf('PlotNodeNumber for %s\n',Th.info.name);
    PlotMesh(Th,'RGBcolors',selectColors(4));
    PlotNodeNumber(Th,'Color',[0 0 1],'FontSize',8);
    pause(tpause);close;
end

if (Th.d==2) && (Th.nme<100)
    fprintf('PlotTriangleNumber for %s\n',Th.info.name);
    PlotMesh(Th,'RGBcolors',selectColors(4));
    PlotNodeNumber(Th,'Color',[0 0 1],'FontSize',8);
    PlotTriangleNumber(Th,'Color',[1 0 0],'FontSize',8);
    pause(tpause);close;
end

if (Th.d==2) && (Th.nbe<100)
    fprintf('PlotEdgeNumber for %s\n',Th.info.name);
    PlotMesh(Th,'RGBcolors',selectColors(length(unique(Th.bel))+1));
    RGBcolors=PlotBounds(Th,'LineWidth',2);
    PlotEdgeNumber(Th,'RGBEdgeColors',RGBcolors,'Color',[0 0 0],'LineStyle','-','LineWidth',0.5,'FontSize',8);
    PlotNodeNumber(Th,'Color',[0 0 1],'FontSize',8)
    PlotTriangleNumber(Th,'Color',[1 0 0],'FontSize',8)
    pause(tpause);close;
end

%if (Th.d==2) && (Th.nme<100)
%    fprintf('PlotBasisFunc for %s\n',Th.info.name);
%PlotMesh(Th);
% PlotBasisFunc(Th,3);
%pause(tpause);close;
%end

fprintf('\n');
end

