% PlotEdgeNumberfull.m
% Demo of PlotEdgeNumber function
% PlotMesh, PlotBounds, PlotNodeNumber and PlotTriangleNumber are also used.
%  The mesh is provided by the meshes.tar.gz archive.
% This figure is included in the report to describe the mesh structure.
Th=GetMeshOpt('Ring-3.msh',2);
mVisuMesh.graphics.PlotMesh(Th,'RGBcolors', mVisuMesh.graphics.selectColors(length( unique(Th.bel))+1));
RGBcolors=mVisuMesh.graphics.PlotBounds(Th,'FontSize',15);
mVisuMesh.graphics.PlotEdgeNumber(Th,'RGBEdgeColors', RGBcolors, 'Color',[0 0 0],'LineStyle','-', 'LineWidth',0.5,'FontSize',12);
mVisuMesh.graphics.PlotNodeNumber(Th,'Color',[0 0 1],'FontSize',12);
mVisuMesh.graphics.PlotTriangleNumber(Th,'Color',[1 0 0],'FontSize',12);
%set(legend(),'FontSize',24);
if ~mVisuMesh.utils.isOctave()
set(legend(),'Location','BestOutside');
end
