function  varargout=PlotIsolines(Th,U,varargin)
% function h=PlotIsolines(Th,U,varargin)
%   To plot isolines of a scalar field in 2D
%
% parameters:
%   Th  : mesh structure
%   U : array of doubles of size Th.nq
%
% Optional parameters (of type addParameter):
%   niso: (integer) number of isolines to be plotted. Default is 10
%   colormap : (string) To set colormap value to \'jet\', \'hsv\', \'gray\',
%   \'colorcube\',\'cool\',\'spring\',\'summer\',..  Default value is 'jet'.
%   colorbar : (bool) To set colorbar visible or not. Default is false
%   PlotOptions (optional parameter of type addParameter) is a cell for defining plotting options. Default value is an empty cell.
%   plan: (bool) To plot isolines in 2D in the xOy-plane (if true) or
%   in 3D (if false). 
%   isorange: array of integers which defines the isoline values. Default value is an empty array and niso isoline values are set in proportion in the range of minimum and maximum values.
%   labels : (array of integers). To plot isolines only on specific regions. Default value is the empty array.
%
% Optional output parameter:
% varargout{1} is the array of RGB colors used by the plot, varargout{2} is the array of isoline values.
%
% Example:
% Th=GetMeshOpt('disk4-1-50.msh',2);
% x=Th.q(1,:);y=Th.q(2,:);
% u=2+cos(pi*(x.^2+y.^2));
% PlotIsolines(Th,u,'colormap','cool');
%

% PlotOptions={'Color','w','LineWidth',2}
p = inputParser;
p=mVisuMesh.utils.AddParamValue(p,'niso',10,@isscalar);
p=mVisuMesh.utils.AddParamValue(p,'colormap','jet',@ischar);
p=mVisuMesh.utils.AddParamValue(p,'colorbar',false,@islogical);
%  p=mVisuMesh.utils.AddParamValue(p,'color',[]); % unique color %interet (GS)?
p=mVisuMesh.utils.AddParamValue(p,'PlotOptions',{},@iscell);
p=mVisuMesh.utils.AddParamValue(p,'plan', false , @islogical );
p=mVisuMesh.utils.AddParamValue(p,'isorange',[]);
p=mVisuMesh.utils.AddParamValue(p,'labels', [], @isnumeric ); % @(v) isempty(setdiff(v,unique(Th.mel)))
p=mVisuMesh.utils.Parse(p,varargin{:});

R=p.Results;
ListSubDomLabel=unique(Th.mel);
if ~isempty(R.labels)
    if isempty(setdiff(R.labels,ListSubDomLabel))
        ListSubDomLabel=R.labels;
    else
        error('Wrong labels');
    end
end
if size(ListSubDomLabel,2)==1, ListSubDomLabel=ListSubDomLabel';end;
AllInd=[];
for i=ListSubDomLabel
    indx=find(Th.mel==i);
    AllInd=[AllInd;indx];
end

if (isempty(R.isorange) && R.niso>1), R.isorange=linspace(min(U),max(U),R.niso);end
R.niso=length(R.isorange);
if size(U,1)==1, U=U';end
[LS,LD,I] = isolines(Th.q',Th.me(:,AllInd)',U,R.isorange);
if isempty(R.colormap)
    colors = mVisuMesh.graphics.selectColors(R.niso);
else
    cmap=colormap(R.colormap);
    t=0:1/(R.niso-1):1;
    colors = RGB(t,cmap);
end

hold on
axis equal
for i=1:R.niso
    II=find(I==i);
    % Correctif Bug d'affichage avec plot => plot3
    %plotval & plotisolines() a tester sur 2015a - ce qui suit est une
    %alternative
    if Th.dim==2
      if R.plan
        hd=plot([LS(II,1) LD(II,1)]',[LS(II,2) LD(II,2)]','color',colors(i,:),R.PlotOptions{:});
      else
        hd=plot3([LS(II,1) LD(II,1)]',[LS(II,2) LD(II,2)]',R.isorange(i)*ones(2,size(II,1)),'color',colors(i,:),R.PlotOptions{:});
      end
    else
        hd=plot3([LS(II,1) LD(II,1)]',[LS(II,2) LD(II,2)]',[LS(II,3) LD(II,3)]','color',colors(i,:),R.PlotOptions{:});
    end
end
if R.colorbar
    if mVisuMesh.utils.isOctave()
        caxis([R.isorange(1), R.isorange(end)])
        colorbar
    else
        colorbarIso(colors,R.isorange)
    end
end
if nargout>=1, varargout{1}=colors;end
if nargout==2, varargout{2}=R.isorange;end
end
