function Bh=NormalBoundaryFaces(Th,Bh)
  d=Th.d;
  [IndLocFaces,IndOpositePt]=mVisuMesh.mesh.getIndLocFaces(d);
  Normals=NormalFaces(Th);
  % On cherche les faces du bord
  % il y a d+1 faces par d-simplexe. Les faces sont des (d-1)-simplexes (avec d points)
  % 1) On construit toutes les faces des d-simplexes (avec doublons)
  %    Il y a en tout Th.nme*(d+1)  (d-1)-simplexes
  AllFaces=zeros(d,Th.nme*(d+1)); I=1:Th.nme;
  IndAllFaces=zeros(2,Th.nme*(d+1));
  for i=1:d+1
    AllFaces(:,I+(i-1)*Th.nme)=Th.me(IndLocFaces(i,:),:);
    IndAllFaces(1,I+(i-1)*Th.nme)=1:Th.nme; % indices du d-simplex d'appartenance des faces 
    IndAllFaces(2,I+(i-1)*Th.nme)=i; % local faces number
  end
  SortAllFaces=sort(AllFaces)';
  [UniqueSortAllFaces,ia,ic]=unique(SortAllFaces,'rows');%,'stable');
  SelectIndAllFaces=IndAllFaces(:,ia);
 
  A=[UniqueSortAllFaces;sort(Th.be)'];
  [C,IA,IC]=unique(A,'rows'); 
  Ind=IC(end-Th.nbe+1:end);
  for l=1:length(Bh)
    I=find(Th.bel==Bh(l).label);
    J=Ind(I);
    Bh(l).Normals=zeros(d,Bh(l).nme);
    II=SelectIndAllFaces(2,J);
    KK=SelectIndAllFaces(1,J);
    for i=1:d
      sind=sub2ind([d+1,d,Th.nme],II,i*ones(1,Bh(l).nme),KK);
      Bh(l).Normals(i,:)=Normals(sind);
    end
  end
end