function PlotTriangleNumber(varargin)
% function PlotTriangleNumber(varargin)
%   To write mesh triangle numbers on figure
%
% parameters:
%   Th  : mesh structure
%   BackgroundColor : RGB value to set the background box color for
%   triangle numbering. Default value is [1 1 1] (white).
%   FontSize : To set font size for triangle numbering. Default value is 10.
%   Color : RGB value to define triangle number color. Default value is [0 0 0] (black).
%   EdgeColor : RGB value To set triangle number box edge color. Default value is [0 0 0] (black).
%   C: integer equal to 0 or 1 for the numbering shift (if C=1, numbering starts from 0). Default value is 0.
% Example:
%  @verbatim 
%   PlotTriangleNumber(Th,'Color',[1 0 0]);@endverbatim
%
% 
p = inputParser; 
p=mVisuMesh.utils.AddRequired(p,'Th', @isstruct);
%  
p=mVisuMesh.utils.AddParamValue(p,'BackgroundColor', [1 1 1], @isnumeric );
p=mVisuMesh.utils.AddParamValue(p,'FontSize', 10, @isnumeric );
p=mVisuMesh.utils.AddParamValue(p,'Color', [0 0 0] , @isnumeric );
p=mVisuMesh.utils.AddParamValue(p,'EdgeColor', [0 0 0] , @isnumeric );
p=mVisuMesh.utils.AddParamValue(p,'C', 0 , @isnumeric ); % for numbering shift (if C=1, numbering starts from 0)
p=mVisuMesh.utils.Parse(p,varargin{:});
R=p.Results;
PrevHold=SetHoldOn(true);
CP=(R.Th.q(:,R.Th.me(1,:))+R.Th.q(:,R.Th.me(2,:))+R.Th.q(:,R.Th.me(3,:)))/3;
text(CP(1,:),CP(2,:),num2str([1:R.Th.nme]'-R.C), ...
     'BackgroundColor',R.BackgroundColor,'Color',R.Color, ...
     'FontSize',R.FontSize,'EdgeColor', R.EdgeColor, ...
     'HorizontalAlignment','center'); 
RestoreHold(PrevHold)
